/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.orchestration;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.netflix.spinnaker.clouddriver.config.ExceptionClassifierConfigurationProperties;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.exceptions.SpinnakerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExceptionClassifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExceptionClassifier.class);
    private final ExceptionClassifierConfigurationProperties properties;
    private final DynamicConfigService dynamicConfigService;

    public ExceptionClassifier(ExceptionClassifierConfigurationProperties properties, DynamicConfigService dynamicConfigService) {
        this.properties = properties;
        this.dynamicConfigService = dynamicConfigService;
    }

    public boolean isRetryable(@Nonnull Exception e) {
        if (e instanceof SpinnakerException) {
            return Optional.ofNullable(((SpinnakerException)e).getRetryable()).orElse(false);
        }
        boolean retryable = false;
        try {
            String dynamicRetraybleClasses = (String)this.dynamicConfigService.getConfig(String.class, "clouddriver.exception-classifier.retryable-exceptions", (Object)String.join((CharSequence)",", this.properties.getRetryableClasses()));
            if (dynamicRetraybleClasses != null) {
                ArrayList dynamicRetraybleClassesList = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)dynamicRetraybleClasses));
                List retryableClasses = Stream.of(dynamicRetraybleClassesList, this.properties.getRetryableClasses()).flatMap(Collection::stream).collect(Collectors.toList());
                retryable = retryableClasses.contains(e.getClass().getName());
            } else {
                retryable = this.properties.getRetryableClasses().contains(e.getClass().getName());
            }
        }
        catch (Exception caughtException) {
            log.error("Unexpected exception while processing retryable classes", (Throwable)caughtException);
        }
        log.trace("Evaluated retryable status for {} to '{}'", (Object)e.getClass().getName(), (Object)retryable);
        return retryable;
    }
}

