/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.orchestration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.data.task.SagaId;
import com.netflix.spinnaker.clouddriver.deploy.DescriptionAuthorizer;
import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidationErrors;
import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidationException;
import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidator;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationConverter;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationDescriptionPreProcessor;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationNotFoundException;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationsRegistry;
import com.netflix.spinnaker.clouddriver.orchestration.OperationDescription;
import com.netflix.spinnaker.clouddriver.orchestration.SagaContextAware;
import com.netflix.spinnaker.clouddriver.orchestration.sagas.AbstractSagaAtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.sagas.SnapshotAtomicOperationInput;
import com.netflix.spinnaker.clouddriver.saga.models.Saga;
import com.netflix.spinnaker.clouddriver.saga.persistence.SagaRepository;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsRepository;
import com.netflix.spinnaker.clouddriver.security.AllowedAccountsValidator;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import com.netflix.spinnaker.kork.web.exceptions.ExceptionMessageDecorator;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;

public class OperationsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OperationsService.class);
    private final Splitter COMMA_SPLITTER = Splitter.on((String)",");
    private final AtomicOperationsRegistry atomicOperationsRegistry;
    private final List<DescriptionAuthorizer> descriptionAuthorizers;
    private final Collection<AllowedAccountsValidator> allowedAccountValidators;
    private final List<AtomicOperationDescriptionPreProcessor> atomicOperationDescriptionPreProcessors;
    private final AccountCredentialsRepository accountCredentialsRepository;
    private final Optional<SagaRepository> sagaRepository;
    private final Registry registry;
    private final ObjectMapper objectMapper;
    private final ExceptionMessageDecorator exceptionMessageDecorator;
    private final Id validationErrorsCounterId;

    public OperationsService(AtomicOperationsRegistry atomicOperationsRegistry, List<DescriptionAuthorizer> descriptionAuthorizers, Optional<Collection<AllowedAccountsValidator>> allowedAccountValidators, Optional<List<AtomicOperationDescriptionPreProcessor>> atomicOperationDescriptionPreProcessors, AccountCredentialsRepository accountCredentialsRepository, Optional<SagaRepository> sagaRepository, Registry registry, ObjectMapper objectMapper, ExceptionMessageDecorator exceptionMessageDecorator) {
        this.atomicOperationsRegistry = atomicOperationsRegistry;
        this.descriptionAuthorizers = descriptionAuthorizers;
        this.allowedAccountValidators = allowedAccountValidators.orElse(Collections.emptyList());
        this.atomicOperationDescriptionPreProcessors = atomicOperationDescriptionPreProcessors.orElse(Collections.emptyList());
        this.accountCredentialsRepository = accountCredentialsRepository;
        this.sagaRepository = sagaRepository;
        this.registry = registry;
        this.objectMapper = objectMapper;
        this.exceptionMessageDecorator = exceptionMessageDecorator;
        this.validationErrorsCounterId = registry.createId("validationErrors");
    }

    @Nonnull
    public List<AtomicOperation> collectAtomicOperations(@Nonnull List<Map<String, Map<String, Object>>> inputs) {
        return this.collectAtomicOperations(null, inputs);
    }

    @Nonnull
    public List<AtomicOperation> collectAtomicOperations(@Nullable String cloudProvider, @Nonnull List<Map<String, Map<String, Object>>> inputs) {
        List<AtomicOperationBindingResult> results = this.convert(cloudProvider, inputs);
        ArrayList<AtomicOperation> atomicOperations = new ArrayList<AtomicOperation>();
        results.forEach(bindingResult -> {
            if (bindingResult.errors.hasErrors()) {
                Collection<String> errors = this.collectErrors(bindingResult.errors);
                throw new DescriptionValidationException(errors);
            }
            atomicOperations.add(bindingResult.atomicOperation);
        });
        return atomicOperations;
    }

    private List<AtomicOperationBindingResult> convert(@Nullable String cloudProvider, @Nonnull List<Map<String, Map<String, Object>>> inputs) {
        String username = AuthenticatedRequest.getSpinnakerUser().orElse("unknown");
        List allowedAccounts = this.COMMA_SPLITTER.splitToList((CharSequence)AuthenticatedRequest.getSpinnakerAccounts().orElse(""));
        ArrayList descriptions = new ArrayList();
        return inputs.stream().flatMap(input -> input.entrySet().stream().map(e -> {
            AtomicOperation atomicOperation;
            String descriptionName = (String)e.getKey();
            Map descriptionInput = (Map)e.getValue();
            OperationInput operationInput = (OperationInput)this.objectMapper.convertValue((Object)descriptionInput, OperationInput.class);
            String provider = Optional.ofNullable(cloudProvider).orElse(operationInput.cloudProvider);
            AtomicOperationConverter converter = this.atomicOperationsRegistry.getAtomicOperationConverter(descriptionName, provider);
            Map<String, Object> processedInput = OperationsService.processDescriptionInput(this.atomicOperationDescriptionPreProcessors, converter, descriptionInput);
            OperationDescription description = converter.convertDescription(processedInput);
            descriptions.add(description);
            DescriptionValidationErrors errors = new DescriptionValidationErrors(description);
            DescriptionValidator validator = this.atomicOperationsRegistry.getAtomicOperationDescriptionValidator(DescriptionValidator.getValidatorName((String)descriptionName), provider);
            if (validator == null) {
                String operationName = Optional.ofNullable(description).map(it -> it.getClass().getSimpleName()).orElse("UNKNOWN");
                log.warn("No validator found for operation {} and cloud provider {}", (Object)operationName, (Object)provider);
            } else {
                validator.validate(descriptions, (Object)description, (ValidationErrors)errors);
            }
            this.allowedAccountValidators.forEach(it -> it.validate(username, (Collection)allowedAccounts, (Object)description, (Errors)errors));
            if (description != null) {
                DescriptionAuthorizer descriptionAuthorizer = this.descriptionAuthorizers.stream().filter(it -> it.supports(description)).findFirst().orElseThrow(() -> new SystemException("Unable to find supporting description authorizer for {}", description.getClass().getSimpleName()));
                descriptionAuthorizer.authorize(description, (Errors)errors);
            }
            if ((atomicOperation = converter.convertOperation(processedInput)) == null) {
                throw new AtomicOperationNotFoundException(descriptionName);
            }
            if (atomicOperation instanceof SagaContextAware) {
                ((SagaContextAware)atomicOperation).setSagaContext(new SagaContextAware.SagaContext(cloudProvider, descriptionName, descriptionInput));
            }
            if (errors.hasErrors()) {
                this.registry.counter(this.validationErrorsCounterId.withTag("operation", atomicOperation.getClass().getSimpleName())).increment();
            }
            return new AtomicOperationBindingResult(atomicOperation, (Errors)errors);
        })).collect(Collectors.toList());
    }

    public List<AtomicOperation> collectAtomicOperationsFromSagas(Set<SagaId> sagaIds) {
        if (this.sagaRepository.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList seenDescriptions = new ArrayList();
        return sagaIds.stream().map(id -> this.sagaRepository.get().get(id.getName(), id.getId())).filter(Objects::nonNull).filter(it -> !it.isComplete()).map(saga -> new SagaAndSnapshot((Saga)saga, (SnapshotAtomicOperationInput.SnapshotAtomicOperationInputCommand)saga.getEvent(SnapshotAtomicOperationInput.SnapshotAtomicOperationInputCommand.class))).filter(it -> {
            if (seenDescriptions.contains(it.getSnapshot().getDescription())) {
                return false;
            }
            seenDescriptions.add(it.getSnapshot().getDescription());
            return true;
        }).flatMap(saga -> {
            List<AtomicOperationBindingResult> bindingResult = this.convert(saga.getSnapshot().getCloudProvider(), Collections.singletonList(Collections.singletonMap(saga.getSnapshot().getDescriptionName(), saga.getSnapshot().getDescriptionInput())));
            return bindingResult.stream().map(this::atomicOperationOrError).peek(it -> {
                if (it instanceof AbstractSagaAtomicOperation) {
                    AbstractSagaAtomicOperation op = (AbstractSagaAtomicOperation)it;
                    Optional.ofNullable(op.getSagaContext()).ifPresent(context -> context.setSagaId(saga.getSaga().getId()));
                }
            });
        }).collect(Collectors.toList());
    }

    private AtomicOperation atomicOperationOrError(AtomicOperationBindingResult bindingResult) {
        if (bindingResult.errors.hasErrors()) {
            Collection<String> errors = this.collectErrors(bindingResult.errors);
            throw new DescriptionValidationException(errors);
        }
        return bindingResult.atomicOperation;
    }

    private Collection<String> collectErrors(Errors errors) {
        ArrayList<String> errorCollection = new ArrayList<String>();
        for (ObjectError objectError : errors.getAllErrors()) {
            if (objectError.getDefaultMessage() != null && objectError.getCode() != null) {
                errorCollection.add(this.exceptionMessageDecorator.decorate(objectError.getCode(), objectError.getDefaultMessage()));
                continue;
            }
            if (objectError.getCode() == null) continue;
            errorCollection.add(this.exceptionMessageDecorator.decorate(objectError.getCode(), objectError.getCode()));
        }
        return errorCollection;
    }

    private static Map<String, Object> processDescriptionInput(Collection<AtomicOperationDescriptionPreProcessor> descriptionPreProcessors, AtomicOperationConverter converter, Map<String, Object> descriptionInput) {
        Method convertDescriptionMethod;
        try {
            convertDescriptionMethod = converter.getClass().getMethod("convertDescription", Map.class);
        }
        catch (NoSuchMethodException e) {
            throw new SystemException("Could not find convertDescription method on converter", (Throwable)e);
        }
        Class convertDescriptionReturnType = ResolvableType.forMethodReturnType((Method)convertDescriptionMethod).getRawClass();
        for (AtomicOperationDescriptionPreProcessor preProcessor : descriptionPreProcessors) {
            if (!preProcessor.supports(convertDescriptionReturnType)) continue;
            descriptionInput = preProcessor.process(descriptionInput);
        }
        return descriptionInput;
    }

    private static class SagaAndSnapshot {
        Saga saga;
        SnapshotAtomicOperationInput.SnapshotAtomicOperationInputCommand snapshot;

        @Generated
        public Saga getSaga() {
            return this.saga;
        }

        @Generated
        public SnapshotAtomicOperationInput.SnapshotAtomicOperationInputCommand getSnapshot() {
            return this.snapshot;
        }

        @Generated
        public SagaAndSnapshot setSaga(Saga saga) {
            this.saga = saga;
            return this;
        }

        @Generated
        public SagaAndSnapshot setSnapshot(SnapshotAtomicOperationInput.SnapshotAtomicOperationInputCommand snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SagaAndSnapshot)) {
                return false;
            }
            SagaAndSnapshot other = (SagaAndSnapshot)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Saga this$saga = this.getSaga();
            Saga other$saga = other.getSaga();
            if (this$saga == null ? other$saga != null : !this$saga.equals(other$saga)) {
                return false;
            }
            SnapshotAtomicOperationInput.SnapshotAtomicOperationInputCommand this$snapshot = this.getSnapshot();
            SnapshotAtomicOperationInput.SnapshotAtomicOperationInputCommand other$snapshot = other.getSnapshot();
            return !(this$snapshot == null ? other$snapshot != null : !((Object)this$snapshot).equals(other$snapshot));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SagaAndSnapshot;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Saga $saga = this.getSaga();
            result = result * 59 + ($saga == null ? 43 : $saga.hashCode());
            SnapshotAtomicOperationInput.SnapshotAtomicOperationInputCommand $snapshot = this.getSnapshot();
            result = result * 59 + ($snapshot == null ? 43 : ((Object)$snapshot).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OperationsService.SagaAndSnapshot(saga=" + this.getSaga() + ", snapshot=" + this.getSnapshot() + ")";
        }

        @Generated
        public SagaAndSnapshot(Saga saga, SnapshotAtomicOperationInput.SnapshotAtomicOperationInputCommand snapshot) {
            this.saga = saga;
            this.snapshot = snapshot;
        }
    }

    private static class OperationInput {
        @Nullable
        private String credentials;
        @Nullable
        private String accountName;
        @Nullable
        private String account;
        @Nullable
        private String cloudProvider;

        @Nullable
        public String computeAccountName() {
            return Optional.ofNullable(this.credentials).orElse(Optional.ofNullable(this.accountName).orElse(this.account));
        }

        @Generated
        public OperationInput() {
        }

        @Nullable
        @Generated
        public String getCredentials() {
            return this.credentials;
        }

        @Nullable
        @Generated
        public String getAccountName() {
            return this.accountName;
        }

        @Nullable
        @Generated
        public String getAccount() {
            return this.account;
        }

        @Nullable
        @Generated
        public String getCloudProvider() {
            return this.cloudProvider;
        }

        @Generated
        public OperationInput setCredentials(@Nullable String credentials) {
            this.credentials = credentials;
            return this;
        }

        @Generated
        public OperationInput setAccountName(@Nullable String accountName) {
            this.accountName = accountName;
            return this;
        }

        @Generated
        public OperationInput setAccount(@Nullable String account) {
            this.account = account;
            return this;
        }

        @Generated
        public OperationInput setCloudProvider(@Nullable String cloudProvider) {
            this.cloudProvider = cloudProvider;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OperationInput)) {
                return false;
            }
            OperationInput other = (OperationInput)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$credentials = this.getCredentials();
            String other$credentials = other.getCredentials();
            if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) {
                return false;
            }
            String this$accountName = this.getAccountName();
            String other$accountName = other.getAccountName();
            if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) {
                return false;
            }
            String this$account = this.getAccount();
            String other$account = other.getAccount();
            if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                return false;
            }
            String this$cloudProvider = this.getCloudProvider();
            String other$cloudProvider = other.getCloudProvider();
            return !(this$cloudProvider == null ? other$cloudProvider != null : !this$cloudProvider.equals(other$cloudProvider));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OperationInput;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $credentials = this.getCredentials();
            result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
            String $accountName = this.getAccountName();
            result = result * 59 + ($accountName == null ? 43 : $accountName.hashCode());
            String $account = this.getAccount();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            String $cloudProvider = this.getCloudProvider();
            result = result * 59 + ($cloudProvider == null ? 43 : $cloudProvider.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OperationsService.OperationInput(credentials=" + this.getCredentials() + ", accountName=" + this.getAccountName() + ", account=" + this.getAccount() + ", cloudProvider=" + this.getCloudProvider() + ")";
        }
    }

    public static final class AtomicOperationBindingResult {
        private final AtomicOperation atomicOperation;
        private final Errors errors;

        @Generated
        public AtomicOperationBindingResult(AtomicOperation atomicOperation, Errors errors) {
            this.atomicOperation = atomicOperation;
            this.errors = errors;
        }

        @Generated
        public AtomicOperation getAtomicOperation() {
            return this.atomicOperation;
        }

        @Generated
        public Errors getErrors() {
            return this.errors;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AtomicOperationBindingResult)) {
                return false;
            }
            AtomicOperationBindingResult other = (AtomicOperationBindingResult)o;
            AtomicOperation this$atomicOperation = this.getAtomicOperation();
            AtomicOperation other$atomicOperation = other.getAtomicOperation();
            if (this$atomicOperation == null ? other$atomicOperation != null : !this$atomicOperation.equals(other$atomicOperation)) {
                return false;
            }
            Errors this$errors = this.getErrors();
            Errors other$errors = other.getErrors();
            return !(this$errors == null ? other$errors != null : !this$errors.equals(other$errors));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AtomicOperation $atomicOperation = this.getAtomicOperation();
            result = result * 59 + ($atomicOperation == null ? 43 : $atomicOperation.hashCode());
            Errors $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : $errors.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OperationsService.AtomicOperationBindingResult(atomicOperation=" + this.getAtomicOperation() + ", errors=" + this.getErrors() + ")";
        }
    }
}

