/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.orchestration.sagas;

import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.SagaContextAware;
import com.netflix.spinnaker.clouddriver.orchestration.sagas.SagaAtomicOperationBridge;
import com.netflix.spinnaker.clouddriver.saga.SagaService;
import com.netflix.spinnaker.clouddriver.saga.flow.SagaFlow;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSagaAtomicOperation<T, SR, R>
implements AtomicOperation<R>,
SagaContextAware {
    @Autowired
    private SagaService sagaService;
    protected T description;
    private SagaContextAware.SagaContext sagaContext;

    public AbstractSagaAtomicOperation(T description) {
        this.description = description;
    }

    @Nonnull
    protected abstract SagaFlow buildSagaFlow(List var1);

    protected abstract void configureSagaBridge(@Nonnull SagaAtomicOperationBridge.ApplyCommandWrapper.ApplyCommandWrapperBuilder var1);

    protected abstract R parseSagaResult(SR var1);

    public R operate(List priorOutputs) {
        Objects.requireNonNull(this.sagaContext, "A saga context must be provided");
        SagaFlow flow = this.buildSagaFlow(priorOutputs);
        SagaAtomicOperationBridge.ApplyCommandWrapper.ApplyCommandWrapperBuilder builder = SagaAtomicOperationBridge.ApplyCommandWrapper.builder().sagaName(this.getClass().getSimpleName()).inputDescription(this.description).priorOutputs(priorOutputs).sagaContext(this.sagaContext).task(TaskRepository.threadLocalTask.get()).sagaFlow(flow);
        this.configureSagaBridge(builder);
        Object result = new SagaAtomicOperationBridge(this.sagaService, this.sagaContext.getSagaId()).apply(builder.build());
        return this.parseSagaResult(result);
    }

    @Override
    public void setSagaContext(@Nonnull SagaContextAware.SagaContext sagaContext) {
        this.sagaContext = sagaContext;
    }

    @Override
    @Nullable
    public SagaContextAware.SagaContext getSagaContext() {
        return this.sagaContext;
    }
}

