/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.orchestration.sagas;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.clouddriver.event.CompositeSpinnakerEvent;
import com.netflix.spinnaker.clouddriver.event.EventMetadata;
import com.netflix.spinnaker.clouddriver.event.SpinnakerEvent;
import com.netflix.spinnaker.clouddriver.saga.ManyCommands;
import com.netflix.spinnaker.clouddriver.saga.SagaCommand;
import com.netflix.spinnaker.clouddriver.saga.exceptions.SagaIntegrationException;
import com.netflix.spinnaker.clouddriver.saga.flow.SagaAction;
import com.netflix.spinnaker.clouddriver.saga.models.Saga;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoadFront50App
implements SagaAction<LoadFront50AppCommand> {
    private static final Logger log = LoggerFactory.getLogger(LoadFront50App.class);
    private final Front50Service front50Service;
    private final ObjectMapper objectMapper;

    @Autowired
    public LoadFront50App(Front50Service front50Service, ObjectMapper objectMapper) {
        this.front50Service = front50Service;
        this.objectMapper = objectMapper;
    }

    private static SagaCommand applyFront50App(SagaCommand command, Front50App loadedApp) {
        if (ManyCommands.class.isAssignableFrom(command.getClass())) {
            for (SagaCommand c : ((ManyCommands)command).getCommands()) {
                LoadFront50App.applyFront50App(c, loadedApp);
            }
        }
        if (command instanceof Front50AppAware) {
            ((Front50AppAware)command).setFront50App(loadedApp);
        }
        return command;
    }

    @Nonnull
    public SagaAction.Result apply(@Nonnull LoadFront50AppCommand command, @Nonnull Saga saga) {
        try {
            Map response = this.front50Service.getApplication(command.getAppName());
            try {
                return new SagaAction.Result((SagaCommand)Optional.ofNullable(response).map(it -> (Front50App)this.objectMapper.convertValue(it, Front50App.class)).map(f -> LoadFront50App.applyFront50App(command.nextCommand, f)).orElse(null), Collections.emptyList());
            }
            catch (IllegalArgumentException e) {
                log.error("Failed to convert front50 application to internal model", (Throwable)e);
                throw new SagaIntegrationException("Failed to convert front50 application to internal model", (Throwable)e);
            }
        }
        catch (Exception e) {
            if (command.isAllowMissing()) {
                return new SagaAction.Result(command.nextCommand, Collections.emptyList());
            }
            log.error("Failed to load front50 application attributes for {}", (Object)command.getAppName(), (Object)e);
            throw new SystemException(String.format("Failed to load front50 application: %s", command.getAppName()), (Throwable)e);
        }
    }

    public static final class Front50App {
        private final String email;
        private final boolean platformHealthOnly;

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public boolean isPlatformHealthOnly() {
            return this.platformHealthOnly;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Front50App)) {
                return false;
            }
            Front50App other = (Front50App)o;
            if (this.isPlatformHealthOnly() != other.isPlatformHealthOnly()) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            return !(this$email == null ? other$email != null : !this$email.equals(other$email));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPlatformHealthOnly() ? 79 : 97);
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LoadFront50App.Front50App(email=" + this.getEmail() + ", platformHealthOnly=" + this.isPlatformHealthOnly() + ")";
        }

        @Generated
        public Front50App(String email, boolean platformHealthOnly) {
            this.email = email;
            this.platformHealthOnly = platformHealthOnly;
        }

        @Generated
        private Front50App() {
            this.email = null;
            this.platformHealthOnly = false;
        }
    }

    @JsonDeserialize(builder=LoadFront50AppCommandBuilder.class)
    @JsonTypeName(value="loadFront50AppCommand")
    public static final class LoadFront50AppCommand
    implements SagaCommand,
    CompositeSpinnakerEvent {
        @Nonnull
        private final String appName;
        @Nonnull
        private final SagaCommand nextCommand;
        private final boolean allowMissing;
        private EventMetadata metadata;

        public void setMetadata(EventMetadata metadata) {
            this.metadata = metadata;
        }

        @Nonnull
        public List<SpinnakerEvent> getComposedEvents() {
            return Collections.singletonList(this.nextCommand);
        }

        @Generated
        LoadFront50AppCommand(@Nonnull String appName, @Nonnull SagaCommand nextCommand, boolean allowMissing, EventMetadata metadata) {
            if (appName == null) {
                throw new IllegalArgumentException("appName is marked non-null but is null");
            }
            if (nextCommand == null) {
                throw new IllegalArgumentException("nextCommand is marked non-null but is null");
            }
            this.appName = appName;
            this.nextCommand = nextCommand;
            this.allowMissing = allowMissing;
            this.metadata = metadata;
        }

        @Generated
        public static LoadFront50AppCommandBuilder builder() {
            return new LoadFront50AppCommandBuilder();
        }

        @Generated
        public LoadFront50AppCommandBuilder toBuilder() {
            return new LoadFront50AppCommandBuilder().appName(this.appName).nextCommand(this.nextCommand).allowMissing(this.allowMissing).metadata(this.metadata);
        }

        @Nonnull
        @Generated
        public String getAppName() {
            return this.appName;
        }

        @Nonnull
        @Generated
        public SagaCommand getNextCommand() {
            return this.nextCommand;
        }

        @Generated
        public boolean isAllowMissing() {
            return this.allowMissing;
        }

        @Generated
        public EventMetadata getMetadata() {
            return this.metadata;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoadFront50AppCommand)) {
                return false;
            }
            LoadFront50AppCommand other = (LoadFront50AppCommand)o;
            if (this.isAllowMissing() != other.isAllowMissing()) {
                return false;
            }
            String this$appName = this.getAppName();
            String other$appName = other.getAppName();
            if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
                return false;
            }
            SagaCommand this$nextCommand = this.getNextCommand();
            SagaCommand other$nextCommand = other.getNextCommand();
            if (this$nextCommand == null ? other$nextCommand != null : !this$nextCommand.equals(other$nextCommand)) {
                return false;
            }
            EventMetadata this$metadata = this.getMetadata();
            EventMetadata other$metadata = other.getMetadata();
            return !(this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAllowMissing() ? 79 : 97);
            String $appName = this.getAppName();
            result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
            SagaCommand $nextCommand = this.getNextCommand();
            result = result * 59 + ($nextCommand == null ? 43 : $nextCommand.hashCode());
            EventMetadata $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "LoadFront50App.LoadFront50AppCommand(appName=" + this.getAppName() + ", nextCommand=" + this.getNextCommand() + ", allowMissing=" + this.isAllowMissing() + ", metadata=" + this.getMetadata() + ")";
        }

        @JsonPOJOBuilder(withPrefix="")
        public static class LoadFront50AppCommandBuilder {
            @Generated
            private String appName;
            @Generated
            private SagaCommand nextCommand;
            @Generated
            private boolean allowMissing;
            @Generated
            private EventMetadata metadata;

            @Generated
            LoadFront50AppCommandBuilder() {
            }

            @Generated
            public LoadFront50AppCommandBuilder appName(@Nonnull String appName) {
                this.appName = appName;
                return this;
            }

            @Generated
            public LoadFront50AppCommandBuilder nextCommand(@Nonnull SagaCommand nextCommand) {
                this.nextCommand = nextCommand;
                return this;
            }

            @Generated
            public LoadFront50AppCommandBuilder allowMissing(boolean allowMissing) {
                this.allowMissing = allowMissing;
                return this;
            }

            @Generated
            public LoadFront50AppCommandBuilder metadata(EventMetadata metadata) {
                this.metadata = metadata;
                return this;
            }

            @Generated
            public LoadFront50AppCommand build() {
                return new LoadFront50AppCommand(this.appName, this.nextCommand, this.allowMissing, this.metadata);
            }

            @Generated
            public String toString() {
                return "LoadFront50App.LoadFront50AppCommand.LoadFront50AppCommandBuilder(appName=" + this.appName + ", nextCommand=" + this.nextCommand + ", allowMissing=" + this.allowMissing + ", metadata=" + this.metadata + ")";
            }
        }
    }

    public static interface Front50AppAware {
        public void setFront50App(Front50App var1);
    }
}

