/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.orchestration.sagas;

import com.netflix.spinnaker.clouddriver.data.task.SagaId;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.orchestration.SagaContextAware;
import com.netflix.spinnaker.clouddriver.orchestration.sagas.SnapshotAtomicOperationInput;
import com.netflix.spinnaker.clouddriver.saga.SagaCommand;
import com.netflix.spinnaker.clouddriver.saga.SagaService;
import com.netflix.spinnaker.clouddriver.saga.flow.SagaFlow;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.MDC;

public class SagaAtomicOperationBridge {
    private final SagaService sagaService;
    private final String sagaId;

    public SagaAtomicOperationBridge(SagaService sagaService, String sagaId) {
        this.sagaService = sagaService;
        this.sagaId = sagaId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T apply(@Nonnull ApplyCommandWrapper applyCommand) {
        SagaContextAware.SagaContext sagaContext = applyCommand.sagaContext;
        Task task = applyCommand.task;
        String sagaName = applyCommand.sagaName;
        String sagaId = Optional.ofNullable(this.sagaId).orElseGet(() -> UUID.randomUUID().toString());
        task.addSagaId(SagaId.builder().id(sagaId).name(sagaName).build());
        applyCommand.sagaFlow.injectFirst(SnapshotAtomicOperationInput.class);
        try {
            MDC.put((String)"X-SAGA", (String)(sagaName + "/" + sagaId));
            Object object = this.sagaService.applyBlocking(sagaName, sagaId, applyCommand.sagaFlow, (SagaCommand)SnapshotAtomicOperationInput.SnapshotAtomicOperationInputCommand.builder().cloudProvider(sagaContext.getCloudProvider()).descriptionName(sagaContext.getDescriptionName()).descriptionInput(sagaContext.getOriginalInput()).description(applyCommand.inputDescription).priorOutputs(applyCommand.priorOutputs).nextCommand(applyCommand.initialCommand).build());
            return (T)object;
        }
        finally {
            MDC.remove((String)"X-SAGA");
        }
    }

    public static class ApplyCommandWrapper {
        @Nonnull
        private String sagaName;
        @Nonnull
        private SagaContextAware.SagaContext sagaContext;
        @Nonnull
        private Task task;
        @Nonnull
        private Object inputDescription;
        @Nonnull
        private SagaFlow sagaFlow;
        @Nonnull
        private SagaCommand initialCommand;
        @Nullable
        private List priorOutputs;

        @Generated
        ApplyCommandWrapper(@Nonnull String sagaName, @Nonnull SagaContextAware.SagaContext sagaContext, @Nonnull Task task, @Nonnull Object inputDescription, @Nonnull SagaFlow sagaFlow, @Nonnull SagaCommand initialCommand, @Nullable List priorOutputs) {
            if (sagaName == null) {
                throw new IllegalArgumentException("sagaName is marked non-null but is null");
            }
            if (sagaContext == null) {
                throw new IllegalArgumentException("sagaContext is marked non-null but is null");
            }
            if (task == null) {
                throw new IllegalArgumentException("task is marked non-null but is null");
            }
            if (inputDescription == null) {
                throw new IllegalArgumentException("inputDescription is marked non-null but is null");
            }
            if (sagaFlow == null) {
                throw new IllegalArgumentException("sagaFlow is marked non-null but is null");
            }
            if (initialCommand == null) {
                throw new IllegalArgumentException("initialCommand is marked non-null but is null");
            }
            this.sagaName = sagaName;
            this.sagaContext = sagaContext;
            this.task = task;
            this.inputDescription = inputDescription;
            this.sagaFlow = sagaFlow;
            this.initialCommand = initialCommand;
            this.priorOutputs = priorOutputs;
        }

        @Generated
        public static ApplyCommandWrapperBuilder builder() {
            return new ApplyCommandWrapperBuilder();
        }

        @Generated
        public static class ApplyCommandWrapperBuilder {
            @Generated
            private String sagaName;
            @Generated
            private SagaContextAware.SagaContext sagaContext;
            @Generated
            private Task task;
            @Generated
            private Object inputDescription;
            @Generated
            private SagaFlow sagaFlow;
            @Generated
            private SagaCommand initialCommand;
            @Generated
            private List priorOutputs;

            @Generated
            ApplyCommandWrapperBuilder() {
            }

            @Generated
            public ApplyCommandWrapperBuilder sagaName(@Nonnull String sagaName) {
                this.sagaName = sagaName;
                return this;
            }

            @Generated
            public ApplyCommandWrapperBuilder sagaContext(@Nonnull SagaContextAware.SagaContext sagaContext) {
                this.sagaContext = sagaContext;
                return this;
            }

            @Generated
            public ApplyCommandWrapperBuilder task(@Nonnull Task task) {
                this.task = task;
                return this;
            }

            @Generated
            public ApplyCommandWrapperBuilder inputDescription(@Nonnull Object inputDescription) {
                this.inputDescription = inputDescription;
                return this;
            }

            @Generated
            public ApplyCommandWrapperBuilder sagaFlow(@Nonnull SagaFlow sagaFlow) {
                this.sagaFlow = sagaFlow;
                return this;
            }

            @Generated
            public ApplyCommandWrapperBuilder initialCommand(@Nonnull SagaCommand initialCommand) {
                this.initialCommand = initialCommand;
                return this;
            }

            @Generated
            public ApplyCommandWrapperBuilder priorOutputs(@Nullable List priorOutputs) {
                this.priorOutputs = priorOutputs;
                return this;
            }

            @Generated
            public ApplyCommandWrapper build() {
                return new ApplyCommandWrapper(this.sagaName, this.sagaContext, this.task, this.inputDescription, this.sagaFlow, this.initialCommand, this.priorOutputs);
            }

            @Generated
            public String toString() {
                return "SagaAtomicOperationBridge.ApplyCommandWrapper.ApplyCommandWrapperBuilder(sagaName=" + this.sagaName + ", sagaContext=" + this.sagaContext + ", task=" + this.task + ", inputDescription=" + this.inputDescription + ", sagaFlow=" + this.sagaFlow + ", initialCommand=" + this.initialCommand + ", priorOutputs=" + this.priorOutputs + ")";
            }
        }
    }
}

