/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.requestqueue;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.requestqueue.RequestQueueConfiguration;
import com.netflix.spinnaker.clouddriver.requestqueue.pooled.PooledRequestQueue;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public interface RequestQueue {
    public static final long DEFAULT_TIMEOUT_MILLIS = 60000L;
    public static final long DEFAULT_START_WORK_TIMEOUT_MILLIS = 10000L;

    public static RequestQueue forConfig(DynamicConfigService dynamicConfigService, Registry registry, RequestQueueConfiguration config) {
        if (!config.isEnabled()) {
            return RequestQueue.noop();
        }
        return RequestQueue.pooled(dynamicConfigService, registry, config.getStartWorkTimeoutMillis(), config.getTimeoutMillis(), config.getPoolSize());
    }

    public static RequestQueue noop() {
        return new NOOP();
    }

    public static RequestQueue pooled(DynamicConfigService dynamicConfigService, Registry registry, int poolSize) {
        return RequestQueue.pooled(dynamicConfigService, registry, 10000L, 60000L, poolSize);
    }

    public static RequestQueue pooled(DynamicConfigService dynamicConfigService, Registry registry, long startWorkTimeoutMillis, long timeoutMillis, int poolSize) {
        return new PooledRequestQueue(dynamicConfigService, registry, startWorkTimeoutMillis, timeoutMillis, poolSize);
    }

    default public long getDefaultTimeoutMillis() {
        return 60000L;
    }

    default public long getDefaultStartWorkTimeoutMillis() {
        return 10000L;
    }

    default public <T> T execute(String partition, Callable<T> operation) throws Throwable {
        return this.execute(partition, operation, this.getDefaultStartWorkTimeoutMillis(), this.getDefaultTimeoutMillis(), TimeUnit.MILLISECONDS);
    }

    public <T> T execute(String var1, Callable<T> var2, long var3, long var5, TimeUnit var7) throws Throwable;

    public static class NOOP
    implements RequestQueue {
        @Override
        public <T> T execute(String partition, Callable<T> operation, long startWorkTimeout, long timeout, TimeUnit unit) throws Throwable {
            return operation.call();
        }
    }
}

