/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.requestqueue.pooled;

import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spinnaker.clouddriver.requestqueue.pooled.Promise;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;

class PooledRequest<T>
implements Runnable {
    private final Timer timer;
    private final Promise<T> result;
    private final Callable<T> work;
    private final long startTime = System.nanoTime();

    PooledRequest(Registry registry, String partition, Callable<T> work) {
        this.timer = registry.timer(registry.createId("pooledRequestQueue.enqueueTime", new String[]{"partition", partition}));
        this.result = new Promise(registry, partition);
        this.work = work;
    }

    Promise<T> getPromise() {
        return this.result;
    }

    void cancel() {
        this.result.completeWithException(new CancellationException());
    }

    @Override
    public void run() {
        this.timer.record(System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS);
        if (this.result.shouldStart()) {
            try {
                this.result.complete(this.work.call());
            }
            catch (Throwable t) {
                this.result.completeWithException(t);
            }
        }
    }
}

