/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.requestqueue.pooled;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.requestqueue.RequestQueue;
import com.netflix.spinnaker.clouddriver.requestqueue.pooled.PollCoordinator;
import com.netflix.spinnaker.clouddriver.requestqueue.pooled.PooledRequest;
import com.netflix.spinnaker.clouddriver.requestqueue.pooled.RequestDistributor;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class PooledRequestQueue
implements RequestQueue {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<String, Queue<PooledRequest<?>>> partitionedRequests = new ConcurrentHashMap();
    private final PollCoordinator pollCoordinator = new PollCoordinator();
    private final long defaultStartWorkTimeout;
    private final long defaultTimeout;
    private final int defaultCorePoolSize;
    private final ThreadPoolExecutor executorService;
    private final BlockingQueue<Runnable> submittedRequests;
    private final Collection<Queue<PooledRequest<?>>> requestQueues;
    private final RequestDistributor requestDistributor;
    private final DynamicConfigService dynamicConfigService;
    private final Registry registry;
    private final AtomicBoolean isEnabled = new AtomicBoolean(true);

    public PooledRequestQueue(DynamicConfigService dynamicConfigService, Registry registry, long defaultStartWorkTimeout, long defaultTimeout, int requestPoolSize) {
        if (defaultStartWorkTimeout <= 0L) {
            throw new IllegalArgumentException("defaultStartWorkTimeout");
        }
        if (defaultTimeout <= 0L) {
            throw new IllegalArgumentException("defaultTimeout");
        }
        if (requestPoolSize < 1) {
            throw new IllegalArgumentException("requestPoolSize");
        }
        this.dynamicConfigService = dynamicConfigService;
        this.registry = registry;
        this.defaultStartWorkTimeout = defaultStartWorkTimeout;
        this.defaultTimeout = defaultTimeout;
        this.defaultCorePoolSize = requestPoolSize;
        this.submittedRequests = new LinkedBlockingQueue<Runnable>();
        registry.gauge("pooledRequestQueue.executorQueue.size", this.submittedRequests, Collection::size);
        int actualThreads = requestPoolSize + 1;
        this.executorService = new ThreadPoolExecutor(actualThreads, actualThreads, 0L, TimeUnit.MILLISECONDS, this.submittedRequests, new ThreadFactoryBuilder().setNameFormat(PooledRequestQueue.class.getSimpleName() + "-%d").build());
        registry.gauge("pooledRequestQueue.corePoolSize", (Object)this.executorService, ThreadPoolExecutor::getCorePoolSize);
        this.requestQueues = new CopyOnWriteArrayList();
        this.requestDistributor = new RequestDistributor(registry, this.pollCoordinator, this.executorService, this.requestQueues);
        this.executorService.submit(this.requestDistributor);
        registry.gauge("pooledRequestQueue.enabled", (Object)this.isEnabled, value -> value.get() ? 1.0 : 0.0);
    }

    @PreDestroy
    public void shutdown() {
        PooledRequest req;
        this.requestDistributor.shutdown();
        this.executorService.shutdown();
        while ((req = (PooledRequest)this.submittedRequests.poll()) != null) {
            req.cancel();
        }
    }

    @Override
    public long getDefaultTimeoutMillis() {
        return this.defaultTimeout;
    }

    @Override
    public long getDefaultStartWorkTimeoutMillis() {
        return this.defaultStartWorkTimeout;
    }

    @Override
    public <T> T execute(String partition, Callable<T> operation, long startWorkTimeout, long timeout, TimeUnit unit) throws Throwable {
        LinkedBlockingQueue<PooledRequest<T>> queue;
        if (!this.isEnabled.get()) {
            return operation.call();
        }
        long startTime = System.nanoTime();
        if (!this.partitionedRequests.containsKey(partition)) {
            LinkedBlockingQueue<PooledRequest<T>> newQueue = new LinkedBlockingQueue<PooledRequest<T>>();
            Queue existing = this.partitionedRequests.putIfAbsent(partition, newQueue);
            if (existing == null) {
                this.requestQueues.add(newQueue);
                queue = newQueue;
                this.registry.gauge(this.registry.createId("pooledRequestQueue.partition.size", new String[]{"partition", partition}), queue, Collection::size);
            } else {
                queue = existing;
            }
        } else {
            queue = (LinkedBlockingQueue<PooledRequest<T>>)this.partitionedRequests.get(partition);
        }
        PooledRequest<T> request = new PooledRequest<T>(this.registry, partition, operation);
        queue.offer(request);
        this.pollCoordinator.notifyItemsAdded();
        Id id = this.registry.createId("pooledRequestQueue.totalTime", new String[]{"partition", partition});
        try {
            T result = request.getPromise().blockingGetOrThrow(startWorkTimeout, timeout, unit);
            id = id.withTag("success", "true");
            T t = result;
            return t;
        }
        catch (Throwable t) {
            id = id.withTags("success", "false", "cause", t.getClass().getSimpleName());
            throw t;
        }
        finally {
            this.registry.timer(id).record(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    @Scheduled(fixedDelayString="${request-queue.core-pool-size-refresh-ms:120000}")
    public void refreshCorePoolSize() {
        int currentCorePoolSize = this.executorService.getCorePoolSize();
        int desiredCorePoolSize = (Integer)this.dynamicConfigService.getConfig(Integer.class, "request-queue.pool-size", (Object)this.defaultCorePoolSize) + 1;
        if (desiredCorePoolSize != currentCorePoolSize) {
            this.log.info("Updating core pool size (original: {}, updated: {})", (Object)currentCorePoolSize, (Object)desiredCorePoolSize);
            this.executorService.setCorePoolSize(desiredCorePoolSize);
            this.executorService.setMaximumPoolSize(desiredCorePoolSize);
        }
        this.isEnabled.set(this.dynamicConfigService.isEnabled("request-queue", true));
    }
}

