/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.requestqueue.pooled;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.requestqueue.pooled.PromiseNotStartedException;
import com.netflix.spinnaker.clouddriver.requestqueue.pooled.PromiseTimeoutException;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

class Promise<T> {
    private final CountDownLatch startingLatch = new CountDownLatch(1);
    private final CountDownLatch latch = new CountDownLatch(1);
    private final AtomicReference<Either<T>> result = new AtomicReference();
    private final Registry registry;
    private final String partition;

    Promise(Registry registry, String partition) {
        this.registry = registry;
        this.partition = partition;
    }

    boolean shouldStart() {
        try {
            boolean bl = this.result.get() == null;
            return bl;
        }
        finally {
            this.startingLatch.countDown();
        }
    }

    void complete(T result) {
        this.registry.counter(this.registry.createId("pooledRequestQueue.promise.complete", new String[]{"partition", this.partition})).increment();
        this.result.compareAndSet(null, Either.forResult(result));
        this.startingLatch.countDown();
        this.latch.countDown();
    }

    void completeWithException(Throwable exception) {
        String cause = Optional.ofNullable(exception).map(Object::getClass).map(Class::getSimpleName).orElse("unknown");
        this.registry.counter(this.registry.createId("pooledRequestQueue.promise.exception", new String[]{"partition", this.partition, "cause", cause})).increment();
        this.result.compareAndSet(null, Either.forException(exception));
        this.startingLatch.countDown();
        this.latch.countDown();
    }

    T blockingGetOrThrow(long startWorkTimeout, long timeout, TimeUnit unit) throws Throwable {
        try {
            if (this.startingLatch.await(startWorkTimeout, unit)) {
                if (!this.latch.await(timeout, unit)) {
                    this.registry.counter(this.registry.createId("pooledRequestQueue.promise.timeout", new String[]{"partition", this.partition})).increment();
                    this.completeWithException(new PromiseTimeoutException());
                }
            } else {
                this.registry.counter(this.registry.createId("pooledRequest.promise.notStarted", new String[]{"partition", this.partition})).increment();
                this.completeWithException(new PromiseNotStartedException());
            }
        }
        catch (Throwable t) {
            this.completeWithException(t);
        }
        return this.result.get().getOrThrow();
    }

    private static class Either<T> {
        private final T result;
        private final Throwable exception;

        static <T> Either<T> forResult(T result) {
            return new Either<T>(result, null);
        }

        static <T> Either<T> forException(Throwable exception) {
            return new Either<Object>(null, exception);
        }

        Either(T result, Throwable exception) {
            this.result = result;
            this.exception = exception;
        }

        T getOrThrow() throws Throwable {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }
    }
}

