/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.requestqueue.pooled;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.requestqueue.pooled.PollCoordinator;
import com.netflix.spinnaker.clouddriver.requestqueue.pooled.PooledRequest;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestDistributor
implements Runnable {
    private final AtomicBoolean continueRunning = new AtomicBoolean(true);
    private final PollCoordinator pollCoordinator;
    private final Executor executor;
    private final Collection<Queue<PooledRequest<?>>> requestQueues;
    private final Counter submissionCounter;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    RequestDistributor(Registry registry, PollCoordinator pollCoordinator, Executor executor, Collection<Queue<PooledRequest<?>>> requestQueues) {
        this.pollCoordinator = pollCoordinator;
        this.executor = executor;
        this.requestQueues = requestQueues;
        this.submissionCounter = registry.counter("pooledRequestQueue.submitted");
    }

    void shutdown() {
        this.continueRunning.set(false);
    }

    @Override
    public void run() {
        while (this.continueRunning.get()) {
            this.processPartitions();
        }
    }

    void processPartitions() {
        try {
            boolean hadItems = false;
            this.pollCoordinator.reset();
            for (Queue<PooledRequest<?>> queue : this.requestQueues) {
                PooledRequest<?> request = queue.poll();
                if (request == null) continue;
                hadItems = true;
                this.submissionCounter.increment();
                this.executor.execute(request);
            }
            this.pollCoordinator.waitForItems(hadItems);
        }
        catch (Throwable t) {
            this.log.warn("Throwable during processPartitions", t);
        }
    }
}

