/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.search;

import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.clouddriver.model.ClusterProvider;
import com.netflix.spinnaker.clouddriver.search.SearchProvider;
import com.netflix.spinnaker.clouddriver.search.SearchResultSet;
import com.netflix.spinnaker.fiat.shared.FiatPermissionEvaluator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class ApplicationSearchProvider
implements SearchProvider {
    private final String APPLICATIONS_TYPE = "applications";
    private final Front50Service front50Service;
    private final List<ClusterProvider> clusterProviders;
    private final FiatPermissionEvaluator permissionEvaluator;

    public ApplicationSearchProvider(Front50Service front50Service, List<ClusterProvider> clusterProviders, FiatPermissionEvaluator permissionEvaluator) {
        this.front50Service = front50Service;
        this.clusterProviders = clusterProviders;
        this.permissionEvaluator = permissionEvaluator;
    }

    public ApplicationSearchProvider(Front50Service front50Service, List<ClusterProvider> clusterProviders) {
        this(front50Service, clusterProviders, null);
    }

    public ApplicationSearchProvider(Front50Service front50Service) {
        this(front50Service, List.of(), null);
    }

    @Override
    public String getPlatform() {
        return "front50";
    }

    @Override
    public SearchResultSet search(String query, Integer pageNumber, Integer pageSize) {
        return this.search(query, List.of("applications"), pageNumber, pageSize, Map.of());
    }

    @Override
    public SearchResultSet search(String query, Integer pageNumber, Integer pageSize, Map<String, String> filters) {
        return this.search(query, List.of("applications"), pageNumber, pageSize, filters);
    }

    @Override
    public SearchResultSet search(String query, List<String> types, Integer pageNumber, Integer pageSize) {
        return this.search(query, types, pageNumber, pageSize, Map.of());
    }

    @Override
    public SearchResultSet search(String query, List<String> types, Integer pageNumber, Integer pageSize, Map<String, String> filters) {
        if (!types.contains("applications")) {
            return SearchResultSet.builder().totalMatches(0).build();
        }
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        List<Map<String, Object>> rawResults = this.front50Service.searchByName(query, pageSize, filters);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        rawResults.forEach(application -> {
            String appName = application.get("name").toString().toLowerCase();
            if (this.permissionEvaluator != null && this.permissionEvaluator.hasPermission(auth, (Serializable)((Object)appName), "APPLICATION", (Object)"READ")) {
                application.put("application", appName);
                application.put("type", "applications");
                application.put("url", String.format("/applications/%s", appName));
                application.put("accounts", this.getAccounts(appName));
                results.add((Map<String, Object>)application);
            }
        });
        return new SearchResultSet(results.size(), pageNumber, pageSize, this.getPlatform(), query, results);
    }

    private List<String> getAccounts(String application) {
        return this.clusterProviders.stream().map(provider -> provider.getClusterSummaries(application)).map(Map::keySet).map(Object::toString).distinct().collect(Collectors.toList());
    }

    @Override
    public List<String> excludedFilters() {
        return List.of("cloudProvider");
    }
}

