/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.search;

import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.clouddriver.search.SearchProvider;
import com.netflix.spinnaker.clouddriver.search.SearchResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class ProjectSearchProvider
implements SearchProvider {
    private final String PROJECTS_TYPE = "projects";
    private final Front50Service front50Service;

    @Override
    public String getPlatform() {
        return "front50";
    }

    @Override
    public SearchResultSet search(String query, Integer pageNumber, Integer pageSize) {
        return this.search(query, List.of("projects"), pageNumber, pageSize, Map.of());
    }

    @Override
    public SearchResultSet search(String query, Integer pageNumber, Integer pageSize, Map<String, String> filters) {
        return this.search(query, List.of("projects"), pageNumber, pageSize, filters);
    }

    @Override
    public SearchResultSet search(String query, List<String> types, Integer pageNumber, Integer pageSize) {
        return this.search(query, types, pageNumber, pageSize, Map.of());
    }

    @Override
    public SearchResultSet search(String query, List<String> types, Integer pageNumber, Integer pageSize, Map<String, String> filters) {
        if (!types.contains("projects")) {
            return SearchResultSet.builder().totalMatches(0).build();
        }
        HashMap<String, String> allFilters = new HashMap<String, String>(Map.of("name", query, "applications", query));
        allFilters.putAll(filters);
        List<Map<String, Object>> projects = this.front50Service.searchForProjects(allFilters, pageSize);
        projects.forEach(project -> {
            project.put("type", "projects");
            project.put("url", String.format("/projects/%s", project.get("id")));
        });
        return new SearchResultSet(projects.size(), pageNumber, pageSize, this.getPlatform(), query, projects);
    }

    @Override
    public List<String> excludedFilters() {
        return List.of("cloudProvider");
    }

    @Generated
    public ProjectSearchProvider(Front50Service front50Service) {
        this.front50Service = front50Service;
    }
}

