/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.search.executor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.search.SearchProvider;
import com.netflix.spinnaker.clouddriver.search.SearchQueryCommand;
import com.netflix.spinnaker.clouddriver.search.SearchResultSet;
import com.netflix.spinnaker.clouddriver.search.executor.SearchExecutorConfigProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SearchExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchExecutor.class);
    private Integer timeout;
    private ExecutorService executor;
    @Autowired
    Registry registry;

    SearchExecutor(SearchExecutorConfigProperties configProperties) {
        this.timeout = configProperties.getTimeout();
        this.executor = Executors.newFixedThreadPool(configProperties.getThreadPoolSize(), new ThreadFactoryBuilder().setNameFormat(SearchExecutor.class.getSimpleName() + "-%d").build());
    }

    public List<SearchResultSet> searchAllProviders(List<SearchProvider> providers, SearchQueryCommand searchQuery) {
        List searchTasks = providers.stream().map(p -> new SearchTask((SearchProvider)p, searchQuery, this.registry)).collect(Collectors.toList());
        List resultFutures = null;
        try {
            resultFutures = this.executor.invokeAll(searchTasks, this.timeout.intValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            log.error(String.format("Search for '%s' in '%s' interrupted", searchQuery.getQ(), searchQuery.getPlatform()), (Throwable)ie);
        }
        if (resultFutures == null) {
            return Collections.EMPTY_LIST;
        }
        return resultFutures.stream().map(f -> SearchExecutor.getFuture(f, this.registry, searchQuery.getQ())).collect(Collectors.toList());
    }

    private static SearchResultSet getFuture(Future<SearchResultSet> f, Registry registry, String q) {
        SearchResultSet resultSet = null;
        try {
            resultSet = f.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error(String.format("Retrieving future %s failed", f), (Throwable)e);
        }
        catch (CancellationException e) {
            log.error(String.format("Retrieving result failed due to cancelled task: %s", f));
            String counterId = String.format("searchExecutor.%s.failures", q != null ? q : "*");
            registry.counter(registry.createId(counterId)).increment(1L);
        }
        if (resultSet == null) {
            return new SearchResultSet().setTotalMatches(0).setResults(Collections.EMPTY_LIST);
        }
        return resultSet;
    }

    private static class SearchTask
    implements Callable<SearchResultSet> {
        private SearchProvider provider;
        private SearchQueryCommand searchQuery;
        private Registry registry;

        SearchTask(SearchProvider provider, SearchQueryCommand searchQuery, Registry registry) {
            this.provider = provider;
            this.searchQuery = searchQuery;
            this.registry = registry;
        }

        @Override
        public SearchResultSet call() {
            Map<String, String> filters = this.searchQuery.getFilters().entrySet().stream().filter(e -> !this.provider.excludedFilters().contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            String q = this.searchQuery.getQ();
            try {
                if (this.searchQuery.getType() != null && !this.searchQuery.getType().isEmpty()) {
                    return this.provider.search(q, this.searchQuery.getType(), this.searchQuery.getPage(), this.searchQuery.getPageSize(), filters);
                }
                return this.provider.search(q, this.searchQuery.getPage(), this.searchQuery.getPageSize(), filters);
            }
            catch (Exception e2) {
                log.error(String.format("Search for '%s' in '%s' failed", q, this.searchQuery.getPlatform()), (Throwable)e2);
                String counterId = String.format("searchExecutor.%s.failures", q != null ? q : "*");
                this.registry.counter(this.registry.createId(counterId)).increment(1L);
                return new SearchResultSet().setTotalMatches(0).setResults(Collections.EMPTY_LIST);
            }
        }
    }
}

