/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.security;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationConverter;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import com.netflix.spinnaker.kork.web.exceptions.InvalidRequestException;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAtomicOperationsCredentialsConverter<T extends AccountCredentials<?>>
implements AtomicOperationConverter {
    @Autowired
    private CredentialsRepository<T> credentialsRepository;
    private final ObjectMapper objectMapper = new ObjectMapper().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    @NotNull
    public T getCredentialsObject(@NotNull String name) {
        AccountCredentials creds = (AccountCredentials)this.credentialsRepository.getOne(name);
        if (creds == null) {
            throw new InvalidRequestException(String.format("credentials not found (name: %s, names: %s)", name, this.credentialsRepository.getAll().stream().map(AccountCredentials::getName).collect(Collectors.joining(","))));
        }
        return (T)creds;
    }

    @Generated
    public CredentialsRepository<T> getCredentialsRepository() {
        return this.credentialsRepository;
    }

    @Generated
    public AbstractAtomicOperationsCredentialsConverter<T> setCredentialsRepository(CredentialsRepository<T> credentialsRepository) {
        this.credentialsRepository = credentialsRepository;
        return this;
    }

    @Generated
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

