/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.security;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperationConverter;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import com.netflix.spinnaker.kork.web.exceptions.InvalidRequestException;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractAtomicOperationsCredentialsSupport
implements AtomicOperationConverter {
    @Autowired
    private AccountCredentialsProvider accountCredentialsProvider;
    private ObjectMapper objectMapper;

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public <T extends AccountCredentials> T getCredentialsObject(String name) {
        AccountCredentials credential;
        if (name == null) {
            throw new InvalidRequestException("credentials are required");
        }
        try {
            AccountCredentials repoCredential = this.accountCredentialsProvider.getCredentials(name);
            if (repoCredential == null) {
                throw new NullPointerException();
            }
            credential = repoCredential;
        }
        catch (Exception e) {
            throw new InvalidRequestException(String.format("credentials not found (name: %s, names: %s)", name, this.getAccountCredentialsProvider().getAll().stream().map(AccountCredentials::getName).collect(Collectors.joining(","))), (Throwable)e);
        }
        return (T)credential;
    }

    public AccountCredentialsProvider getAccountCredentialsProvider() {
        return this.accountCredentialsProvider;
    }

    public void setAccountCredentialsProvider(AccountCredentialsProvider accountCredentialsProvider) {
        this.accountCredentialsProvider = accountCredentialsProvider;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

