/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.security;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionSecretManager;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinition;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.secrets.EncryptedSecret;
import com.netflix.spinnaker.kork.secrets.SecretSession;
import com.netflix.spinnaker.kork.secrets.user.UserSecretReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

@NonnullByDefault
public class AccountDefinitionMapper {
    private final ObjectMapper objectMapper;
    private final AccountDefinitionSecretManager secretManager;
    private final SecretSession secretSession;

    public String serialize(CredentialsDefinition definition) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString((Object)definition);
    }

    public CredentialsDefinition deserialize(String string) throws JsonProcessingException {
        ObjectNode account = (ObjectNode)this.objectMapper.readTree(string);
        String accountName = account.required("name").asText();
        Iterator it = account.fields();
        while (it.hasNext()) {
            Optional<String> plaintext;
            Map.Entry field = (Map.Entry)it.next();
            JsonNode node = (JsonNode)field.getValue();
            if (!node.isTextual()) continue;
            String text = node.asText();
            if (UserSecretReference.isUserSecret((String)text)) {
                UserSecretReference ref = UserSecretReference.parse((String)text);
                plaintext = Optional.of(this.secretManager.getUserSecretString(ref, accountName));
            } else {
                plaintext = EncryptedSecret.isEncryptedSecret((String)text) ? Optional.ofNullable(this.secretSession.decrypt(text)) : Optional.empty();
            }
            plaintext.map(arg_0 -> ((ObjectNode)account).textNode(arg_0)).ifPresent(field::setValue);
        }
        return (CredentialsDefinition)this.objectMapper.convertValue((Object)account, CredentialsDefinition.class);
    }

    @Generated
    public AccountDefinitionMapper(ObjectMapper objectMapper, AccountDefinitionSecretManager secretManager, SecretSession secretSession) {
        this.objectMapper = objectMapper;
        this.secretManager = secretManager;
        this.secretSession = secretSession;
    }
}

