/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.security;

import com.netflix.spinnaker.clouddriver.security.AccountSecurityPolicy;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.secrets.EncryptedSecret;
import com.netflix.spinnaker.kork.secrets.SecretDecryptionException;
import com.netflix.spinnaker.kork.secrets.StandardSecretParameter;
import com.netflix.spinnaker.kork.secrets.user.UserSecret;
import com.netflix.spinnaker.kork.secrets.user.UserSecretManager;
import com.netflix.spinnaker.kork.secrets.user.UserSecretReference;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

@NonnullByDefault
public class AccountDefinitionSecretManager {
    private final UserSecretManager userSecretManager;
    private final AccountSecurityPolicy policy;
    private final Map<String, Set<UserSecretReference>> refsByAccountName = new ConcurrentHashMap<String, Set<UserSecretReference>>();

    public String getUserSecretString(UserSecretReference reference, String accountName) {
        UserSecret secret = this.getUserSecret(reference);
        this.refsByAccountName.computeIfAbsent(accountName, ignored -> ConcurrentHashMap.newKeySet()).add(reference);
        String parameterName = StandardSecretParameter.KEY.getParameterName();
        String secretKey = reference.getParameters().getOrDefault(parameterName, "");
        try {
            return secret.getSecretString(secretKey);
        }
        catch (NoSuchElementException e) {
            throw new SecretDecryptionException((Throwable)e);
        }
    }

    public boolean canAccessAccountWithSecrets(String username, String accountName) {
        return this.policy.isAdmin(username) || !this.accountDefinitionUsesUnauthorizedUserSecrets(username, accountName) && this.policy.canUseAccount(username, accountName);
    }

    private boolean accountDefinitionUsesUnauthorizedUserSecrets(String username, String accountName) {
        Set<String> userRoles = this.policy.getRoles(username);
        return this.refsByAccountName.getOrDefault(accountName, Set.of()).stream().map(this::getUserSecret).anyMatch(secret -> Collections.disjoint(secret.getRoles(), userRoles));
    }

    @Generated
    public AccountDefinitionSecretManager(UserSecretManager userSecretManager, AccountSecurityPolicy policy) {
        this.userSecretManager = userSecretManager;
        this.policy = policy;
    }

    @Generated
    public UserSecret getUserSecret(UserSecretReference reference) {
        return this.userSecretManager.getUserSecret(reference);
    }

    @Generated
    public byte[] getExternalSecret(EncryptedSecret reference) {
        return this.userSecretManager.getExternalSecret(reference);
    }

    @Generated
    public String getExternalSecretString(EncryptedSecret reference) {
        return this.userSecretManager.getExternalSecretString(reference);
    }
}

