/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.security;

import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionRepository;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionSecretManager;
import com.netflix.spinnaker.clouddriver.security.AccountSecurityPolicy;
import com.netflix.spinnaker.clouddriver.security.AuthorizedRolesExtractor;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinition;
import com.netflix.spinnaker.kork.annotations.Beta;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import com.netflix.spinnaker.kork.secrets.SecretException;
import com.netflix.spinnaker.kork.secrets.user.UserSecret;
import com.netflix.spinnaker.kork.secrets.user.UserSecretReference;
import com.netflix.spinnaker.kork.web.exceptions.InvalidRequestException;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PostFilter;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.ReflectionUtils;

@NonnullByDefault
@Beta
public class AccountDefinitionService {
    private final AccountDefinitionRepository repository;
    private final AccountDefinitionSecretManager secretManager;
    private final AccountCredentialsProvider accountCredentialsProvider;
    private final AccountSecurityPolicy policy;
    private final List<AuthorizedRolesExtractor> extractors;

    @PreAuthorize(value="@accountSecurity.isAccountManager(authentication.name)")
    @PostFilter(value="@accountDefinitionSecretManager.canAccessAccountWithSecrets(authentication.name, filterObject.name)")
    public List<? extends CredentialsDefinition> listAccountDefinitionsByType(String accountType, int limit, @Nullable String startingAccountName) {
        return this.repository.listByType(accountType, limit, startingAccountName);
    }

    @PreAuthorize(value="@accountSecurity.isAccountManager(authentication.name)")
    public CredentialsDefinition createAccount(CredentialsDefinition definition) {
        String name = definition.getName();
        String username = AuthenticatedRequest.getSpinnakerUser().orElse("anonymous");
        if (this.accountCredentialsProvider.getCredentials(name) != null) {
            throw new InvalidRequestException(String.format("Cannot create an account which already exists (name: %s)", name));
        }
        this.validateAccountWritePermissions(username, definition, AccountAction.CREATE);
        this.repository.create(definition);
        return definition;
    }

    @PreAuthorize(value="@accountSecurity.isAccountManager(authentication.name)")
    public CredentialsDefinition saveAccount(CredentialsDefinition definition) {
        String name = definition.getName();
        String username = AuthenticatedRequest.getSpinnakerUser().orElse("anonymous");
        if (this.accountCredentialsProvider.getCredentials(name) != null && !this.policy.canModifyAccount(username, name)) {
            throw new AccessDeniedException(String.format("Unauthorized to overwrite existing account (name: %s)", name));
        }
        this.validateAccountWritePermissions(username, definition, AccountAction.SAVE);
        this.repository.save(definition);
        return definition;
    }

    @PreAuthorize(value="@accountSecurity.canModifyAccount(authentication.name, #definition.name)")
    public CredentialsDefinition updateAccount(CredentialsDefinition definition) {
        String name = definition.getName();
        if (this.accountCredentialsProvider.getCredentials(name) == null) {
            throw new InvalidRequestException(String.format("Cannot update an account which does not exist (name: %s)", name));
        }
        String username = AuthenticatedRequest.getSpinnakerUser().orElse("anonymous");
        this.validateAccountWritePermissions(username, definition, AccountAction.UPDATE);
        this.repository.update(definition);
        return definition;
    }

    @PreAuthorize(value="@accountSecurity.canModifyAccount(authentication.name, #accountName)")
    public void deleteAccount(String accountName) {
        this.repository.delete(accountName);
    }

    @PreAuthorize(value="@accountSecurity.canModifyAccount(authentication.name, #accountName)")
    public List<AccountDefinitionRepository.Revision> getAccountHistory(String accountName) {
        return this.repository.revisionHistory(accountName);
    }

    private void validateAccountWritePermissions(String username, CredentialsDefinition definition, AccountAction action) {
        if (this.policy.isAdmin(username)) {
            return;
        }
        String accountName = definition.getName();
        Class<?> type = definition.getClass();
        Set authorizedRoles = this.extractors.stream().filter(extractor -> extractor.supportsType(type)).flatMap(extractor -> extractor.getAuthorizedRoles(definition).stream()).collect(Collectors.toSet());
        Set<String> userRoles = this.policy.getRoles(username);
        if (!authorizedRoles.isEmpty() && Collections.disjoint(userRoles, authorizedRoles)) {
            throw new InvalidRequestException(String.format("Cannot %s account without granting permissions for current user (name: %s)", action.name().toLowerCase(Locale.ROOT), accountName));
        }
        HashSet secretReferences = new HashSet();
        ReflectionUtils.doWithFields(type, field -> UserSecretReference.tryParse((Object)field.get(definition)).ifPresent(secretReferences::add), field -> field.getType() == String.class);
        for (UserSecretReference ref : secretReferences) {
            try {
                UserSecret secret = this.secretManager.getUserSecret(ref);
                Set secretRoles = Set.copyOf(secret.getRoles());
                if (!Collections.disjoint(userRoles, secretRoles)) continue;
                throw new AccessDeniedException(String.format("Unauthorized to %s account with user secret %s", action.name().toLowerCase(Locale.ROOT), ref));
            }
            catch (SecretException e) {
                throw new InvalidRequestException((Throwable)e);
            }
        }
    }

    @Generated
    public AccountDefinitionService(AccountDefinitionRepository repository, AccountDefinitionSecretManager secretManager, AccountCredentialsProvider accountCredentialsProvider, AccountSecurityPolicy policy, List<AuthorizedRolesExtractor> extractors) {
        this.repository = repository;
        this.secretManager = secretManager;
        this.accountCredentialsProvider = accountCredentialsProvider;
        this.policy = policy;
        this.extractors = extractors;
    }

    private static enum AccountAction {
        CREATE,
        UPDATE,
        SAVE;

    }
}

