/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.security;

import com.netflix.spinnaker.clouddriver.security.AccountDefinitionRepository;
import com.netflix.spinnaker.clouddriver.security.AccountDefinitionTypes;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinition;
import com.netflix.spinnaker.credentials.definition.CredentialsDefinitionSource;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@NonnullByDefault
public class AccountDefinitionSource<T extends CredentialsDefinition>
implements CredentialsDefinitionSource<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<CredentialsDefinitionSource<T>> sources;

    public AccountDefinitionSource(AccountDefinitionRepository repository, Class<T> type, List<CredentialsDefinitionSource<T>> additionalSources) {
        String typeName = AccountDefinitionTypes.getCredentialsTypeName(type);
        Objects.requireNonNull(typeName, () -> "Class " + type + " is not annotated with type discriminator");
        ArrayList<Object> sources = new ArrayList<Object>(additionalSources.size() + 1);
        sources.add(() -> repository.listByType(typeName).stream().map(type::cast).collect(Collectors.toList()));
        sources.addAll(additionalSources);
        this.sources = List.copyOf(sources);
    }

    public List<T> getCredentialsDefinitions() {
        HashSet seenAccountNames = new HashSet();
        return this.sources.stream().flatMap(source -> source.getCredentialsDefinitions().stream()).filter(definition -> {
            String name = definition.getName();
            if (seenAccountNames.add(name)) {
                return true;
            }
            LOGGER.warn("Duplicate account name detected ({}). Skipping this definition.", (Object)name);
            return false;
        }).collect(Collectors.toList());
    }
}

