/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.security;

import com.netflix.spinnaker.clouddriver.security.AccountSecurityPolicy;
import com.netflix.spinnaker.fiat.model.Authorization;
import com.netflix.spinnaker.fiat.model.UserPermission;
import com.netflix.spinnaker.fiat.model.resources.ResourceType;
import com.netflix.spinnaker.fiat.model.resources.Role;
import com.netflix.spinnaker.fiat.shared.FiatPermissionEvaluator;
import com.netflix.spinnaker.kork.annotations.NonnullByDefault;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;

@NonnullByDefault
public class DefaultAccountSecurityPolicy
implements AccountSecurityPolicy {
    private final FiatPermissionEvaluator permissionEvaluator;

    @Override
    public boolean isAdmin(String username) {
        return Optional.ofNullable(this.permissionEvaluator.getPermission(username)).filter(UserPermission.View::isAdmin).isPresent();
    }

    @Override
    public boolean isAccountManager(String username) {
        return Optional.ofNullable(this.permissionEvaluator.getPermission(username)).filter(permission -> DefaultAccountSecurityPolicy.isAccountManager(permission) || permission.isAdmin()).isPresent();
    }

    @Override
    public Set<String> getRoles(String username) {
        return Optional.ofNullable(this.permissionEvaluator.getPermission(username)).stream().flatMap(permission -> permission.getRoles().stream().map(Role.View::getName)).collect(Collectors.toSet());
    }

    @Override
    public boolean canUseAccount(@Nonnull String username, @Nonnull String account) {
        return Optional.ofNullable(this.permissionEvaluator.getPermission(username)).filter(permission -> permission.isAdmin() || this.permissionEvaluator.hasPermission(username, (Serializable)((Object)account), ResourceType.ACCOUNT.getName(), (Object)Authorization.WRITE)).isPresent();
    }

    @Override
    public boolean canModifyAccount(@Nonnull String username, @Nonnull String account) {
        return Optional.ofNullable(this.permissionEvaluator.getPermission(username)).filter(permission -> permission.isAdmin() || DefaultAccountSecurityPolicy.isAccountManager(permission) && this.permissionEvaluator.hasPermission(username, (Serializable)((Object)account), ResourceType.ACCOUNT.getName(), (Object)Authorization.WRITE)).isPresent();
    }

    private static boolean isAccountManager(UserPermission.View permission) {
        return permission.isAdmin();
    }

    @Generated
    public DefaultAccountSecurityPolicy(FiatPermissionEvaluator permissionEvaluator) {
        this.permissionEvaluator = permissionEvaluator;
    }
}

