/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.docker.registry.health;

import com.google.common.collect.ImmutableList;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.clouddriver.core.AccountHealthIndicator;
import com.netflix.spinnaker.clouddriver.docker.registry.security.DockerRegistryNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import java.util.Optional;

public class DockerRegistryHealthIndicator
extends AccountHealthIndicator<DockerRegistryNamedAccountCredentials> {
    private static final String ID = "docker";
    private AccountCredentialsProvider accountCredentialsProvider;

    public DockerRegistryHealthIndicator(Registry registry, AccountCredentialsProvider accountCredentialsProvider) {
        super(ID, registry);
        this.accountCredentialsProvider = accountCredentialsProvider;
    }

    protected ImmutableList<DockerRegistryNamedAccountCredentials> getAccounts() {
        return (ImmutableList)this.accountCredentialsProvider.getAll().stream().filter(a -> a instanceof DockerRegistryNamedAccountCredentials).map(a -> (DockerRegistryNamedAccountCredentials)((Object)a)).collect(ImmutableList.toImmutableList());
    }

    protected Optional<String> accountHealth(DockerRegistryNamedAccountCredentials accountCredentials) {
        try {
            accountCredentials.getCredentials().getClient().checkV2Availability();
            return Optional.empty();
        }
        catch (RuntimeException e) {
            return Optional.of(e.getMessage());
        }
    }
}

