/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.elasticsearch.converters;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.clouddriver.elasticsearch.converters.UpsertEntityTagsAtomicOperationConverter;
import com.netflix.spinnaker.clouddriver.elasticsearch.descriptions.BulkUpsertEntityTagsDescription;
import com.netflix.spinnaker.clouddriver.elasticsearch.model.ElasticSearchEntityTagsProvider;
import com.netflix.spinnaker.clouddriver.elasticsearch.ops.BulkUpsertEntityTagsAtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.security.AbstractAtomicOperationsCredentialsSupport;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import com.netflix.spinnaker.kork.core.RetrySupport;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="bulkUpsertEntityTagsDescription")
public class BulkUpsertEntityTagsAtomicOperationConverter
extends AbstractAtomicOperationsCredentialsSupport {
    private final ObjectMapper objectMapper;
    private final RetrySupport retrySupport;
    private final Front50Service front50Service;
    private final AccountCredentialsProvider accountCredentialsProvider;
    private final ElasticSearchEntityTagsProvider entityTagsProvider;

    @Autowired
    public BulkUpsertEntityTagsAtomicOperationConverter(ObjectMapper objectMapper, RetrySupport retrySupport, Front50Service front50Service, AccountCredentialsProvider accountCredentialsProvider, ElasticSearchEntityTagsProvider entityTagsProvider) {
        this.objectMapper = objectMapper;
        this.retrySupport = retrySupport;
        this.front50Service = front50Service;
        this.accountCredentialsProvider = accountCredentialsProvider;
        this.entityTagsProvider = entityTagsProvider;
    }

    public AtomicOperation convertOperation(Map input) {
        return new BulkUpsertEntityTagsAtomicOperation(this.retrySupport, this.front50Service, this.accountCredentialsProvider, this.entityTagsProvider, this.convertDescription(input));
    }

    public BulkUpsertEntityTagsDescription convertDescription(Map input) {
        BulkUpsertEntityTagsDescription description = (BulkUpsertEntityTagsDescription)this.objectMapper.convertValue((Object)input, BulkUpsertEntityTagsDescription.class);
        description.entityTags.forEach(upsertEntityTagsDescription -> upsertEntityTagsDescription.getTags().forEach(UpsertEntityTagsAtomicOperationConverter::setTagValueType));
        return description;
    }
}

