/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.elasticsearch.converters;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.clouddriver.elasticsearch.descriptions.DeleteEntityTagsDescription;
import com.netflix.spinnaker.clouddriver.elasticsearch.model.ElasticSearchEntityTagsProvider;
import com.netflix.spinnaker.clouddriver.elasticsearch.ops.DeleteEntityTagsAtomicOperation;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.security.AbstractAtomicOperationsCredentialsSupport;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="deleteEntityTags")
public class DeleteEntityTagsAtomicOperationConverter
extends AbstractAtomicOperationsCredentialsSupport {
    private final ObjectMapper objectMapper;
    private final Front50Service front50Service;
    private final ElasticSearchEntityTagsProvider entityTagsProvider;

    @Autowired
    public DeleteEntityTagsAtomicOperationConverter(ObjectMapper objectMapper, Front50Service front50Service, ElasticSearchEntityTagsProvider entityTagsProvider) {
        this.objectMapper = objectMapper.copy().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.front50Service = front50Service;
        this.entityTagsProvider = entityTagsProvider;
    }

    public AtomicOperation convertOperation(Map input) {
        return this.buildOperation(this.convertDescription(input));
    }

    public AtomicOperation buildOperation(DeleteEntityTagsDescription description) {
        return new DeleteEntityTagsAtomicOperation(this.front50Service, this.entityTagsProvider, description);
    }

    public DeleteEntityTagsDescription convertDescription(Map input) {
        return (DeleteEntityTagsDescription)this.objectMapper.convertValue((Object)input, DeleteEntityTagsDescription.class);
    }
}

