/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.elasticsearch.events;

import com.netflix.spinnaker.clouddriver.elasticsearch.ElasticSearchEntityTagger;
import com.netflix.spinnaker.clouddriver.orchestration.events.CreateServerGroupEvent;
import com.netflix.spinnaker.clouddriver.orchestration.events.OperationEvent;
import com.netflix.spinnaker.clouddriver.orchestration.events.OperationEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateServerGroupEventHandler
implements OperationEventHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ElasticSearchEntityTagger serverGroupTagger;

    @Autowired
    public CreateServerGroupEventHandler(ElasticSearchEntityTagger serverGroupTagger) {
        this.serverGroupTagger = serverGroupTagger;
    }

    public void handle(OperationEvent operationEvent) {
        if (!(operationEvent instanceof CreateServerGroupEvent)) {
            return;
        }
        this.log.debug("Handling create server group event ({})", (Object)operationEvent);
        CreateServerGroupEvent createServerGroupEvent = (CreateServerGroupEvent)operationEvent;
        this.serverGroupTagger.deleteAll(createServerGroupEvent.getCloudProvider(), createServerGroupEvent.getAccountId(), createServerGroupEvent.getRegion(), "servergroup", createServerGroupEvent.getName());
    }
}

