/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.elasticsearch.events;

import com.netflix.spinnaker.clouddriver.elasticsearch.ElasticSearchEntityTagger;
import com.netflix.spinnaker.clouddriver.orchestration.events.DeleteServerGroupEvent;
import com.netflix.spinnaker.clouddriver.orchestration.events.OperationEvent;
import com.netflix.spinnaker.clouddriver.orchestration.events.OperationEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteServerGroupEventHandler
implements OperationEventHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ElasticSearchEntityTagger serverGroupTagger;

    @Autowired
    public DeleteServerGroupEventHandler(ElasticSearchEntityTagger serverGroupTagger) {
        this.serverGroupTagger = serverGroupTagger;
    }

    public void handle(OperationEvent operationEvent) {
        if (!(operationEvent instanceof DeleteServerGroupEvent)) {
            return;
        }
        this.log.debug("Handling delete server group event ({})", (Object)operationEvent);
        DeleteServerGroupEvent deleteServerGroupEvent = (DeleteServerGroupEvent)operationEvent;
        this.serverGroupTagger.deleteAll(deleteServerGroupEvent.getCloudProvider(), deleteServerGroupEvent.getAccountId(), deleteServerGroupEvent.getRegion(), "servergroup", deleteServerGroupEvent.getName());
    }
}

