/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.elasticsearch.ops;

import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.elasticsearch.descriptions.DeleteEntityTagsDescription;
import com.netflix.spinnaker.clouddriver.elasticsearch.model.ElasticSearchEntityTagsProvider;
import com.netflix.spinnaker.clouddriver.model.EntityTags;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.retrofit.exceptions.SpinnakerHttpException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;

public class DeleteEntityTagsAtomicOperation
implements AtomicOperation<Void> {
    private static final String BASE_PHASE = "ENTITY_TAGS";
    private final Front50Service front50Service;
    private final ElasticSearchEntityTagsProvider entityTagsProvider;
    private final DeleteEntityTagsDescription entityTagsDescription;

    public DeleteEntityTagsAtomicOperation(Front50Service front50Service, ElasticSearchEntityTagsProvider entityTagsProvider, DeleteEntityTagsDescription entityTagsDescription) {
        this.front50Service = front50Service;
        this.entityTagsProvider = entityTagsProvider;
        this.entityTagsDescription = entityTagsDescription;
    }

    public Void operate(List priorOutputs) {
        EntityTags currentTags;
        DeleteEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Retrieving %s from Front50", this.entityTagsDescription.getId()));
        try {
            currentTags = this.front50Service.getEntityTags(this.entityTagsDescription.getId());
        }
        catch (SpinnakerHttpException e) {
            if (e.getResponseCode() == HttpStatus.NOT_FOUND.value()) {
                DeleteEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Did not find %s in Front50", this.entityTagsDescription.getId()));
                DeleteEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Deleting %s from ElasticSearch", this.entityTagsDescription.getId()));
                this.entityTagsProvider.delete(this.entityTagsDescription.getId());
                DeleteEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Deleted %s from ElasticSearch", this.entityTagsDescription.getId()));
                return null;
            }
            throw e;
        }
        Collection currentTagNames = currentTags.getTags().stream().map(EntityTags.EntityTag::getName).collect(Collectors.toSet());
        if (this.entityTagsDescription.isDeleteAll() || this.entityTagsDescription.getTags().containsAll(currentTagNames)) {
            DeleteEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Deleting %s from ElasticSearch", this.entityTagsDescription.getId()));
            this.entityTagsProvider.delete(this.entityTagsDescription.getId());
            DeleteEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Deleted %s from ElasticSearch", this.entityTagsDescription.getId()));
            DeleteEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Deleting %s from Front50", this.entityTagsDescription.getId()));
            this.front50Service.deleteEntityTags(this.entityTagsDescription.getId());
            DeleteEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Deleted %s from Front50", this.entityTagsDescription.getId()));
            return null;
        }
        DeleteEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Removing tags from %s (tags: %s)", this.entityTagsDescription.getId(), this.entityTagsDescription.getTags()));
        this.entityTagsDescription.getTags().forEach(arg_0 -> ((EntityTags)currentTags).removeEntityTag(arg_0));
        EntityTags durableEntityTags = this.front50Service.saveEntityTags(currentTags);
        DeleteEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Updated %s in Front50", durableEntityTags.getId()));
        currentTags.setLastModified(durableEntityTags.getLastModified());
        currentTags.setLastModifiedBy(durableEntityTags.getLastModifiedBy());
        this.entityTagsProvider.index(currentTags);
        this.entityTagsProvider.verifyIndex(currentTags);
        DeleteEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Updated %s in ElasticSearch", this.entityTagsDescription.getId()));
        return null;
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }
}

