/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.elasticsearch;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EntityRefIdBuilder {
    public static EntityRefId buildId(String cloudProvider, String entityType, String entityId, String accountId, String region) {
        Objects.requireNonNull(cloudProvider, "cloudProvider must be non-null");
        Objects.requireNonNull(entityType, "entityType must be non-null");
        Objects.requireNonNull(entityId, "entityId must be non-null");
        String id = Stream.of(cloudProvider, entityType, entityId, accountId, region).map(s -> Optional.ofNullable(s).orElse("*")).collect(Collectors.joining(":"));
        return new EntityRefId(id.toLowerCase(), "{{cloudProvider}}:{{entityType}}:{{entityId}}:{{account}}:{{region}}");
    }

    public static class EntityRefId {
        public final String id;
        public final String idPattern;

        EntityRefId(String id, String idPattern) {
            this.id = id;
            this.idPattern = idPattern;
        }
    }
}

