/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.elasticsearch.converters;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.clouddriver.elasticsearch.descriptions.UpsertEntityTagsDescription;
import com.netflix.spinnaker.clouddriver.elasticsearch.model.ElasticSearchEntityTagsProvider;
import com.netflix.spinnaker.clouddriver.elasticsearch.ops.UpsertEntityTagsAtomicOperation;
import com.netflix.spinnaker.clouddriver.model.EntityTags;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.security.AbstractAtomicOperationsCredentialsSupport;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import com.netflix.spinnaker.kork.core.RetrySupport;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="upsertEntityTags")
public class UpsertEntityTagsAtomicOperationConverter
extends AbstractAtomicOperationsCredentialsSupport {
    private final ObjectMapper objectMapper;
    private final RetrySupport retrySupport;
    private final Front50Service front50Service;
    private final AccountCredentialsProvider accountCredentialsProvider;
    private final ElasticSearchEntityTagsProvider entityTagsProvider;

    @Autowired
    public UpsertEntityTagsAtomicOperationConverter(ObjectMapper objectMapper, RetrySupport retrySupport, Front50Service front50Service, AccountCredentialsProvider accountCredentialsProvider, ElasticSearchEntityTagsProvider entityTagsProvider) {
        this.objectMapper = objectMapper.copy().configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.retrySupport = retrySupport;
        this.front50Service = front50Service;
        this.accountCredentialsProvider = accountCredentialsProvider;
        this.entityTagsProvider = entityTagsProvider;
    }

    public AtomicOperation convertOperation(Map input) {
        return this.buildOperation(this.convertDescription(input));
    }

    public AtomicOperation buildOperation(UpsertEntityTagsDescription description) {
        description.getTags().forEach(UpsertEntityTagsAtomicOperationConverter::setTagValueType);
        return new UpsertEntityTagsAtomicOperation(this.retrySupport, this.front50Service, this.accountCredentialsProvider, this.entityTagsProvider, description);
    }

    public UpsertEntityTagsDescription convertDescription(Map input) {
        UpsertEntityTagsDescription upsertEntityTagsDescription = (UpsertEntityTagsDescription)((Object)this.objectMapper.convertValue((Object)input, UpsertEntityTagsDescription.class));
        return upsertEntityTagsDescription;
    }

    static void setTagValueType(EntityTags.EntityTag entityTag) {
        if (entityTag.getValueType() == null) {
            boolean isObject = entityTag.getValue() instanceof Map || entityTag.getValue() instanceof Collection;
            entityTag.setValueType(isObject ? EntityTags.EntityTagValueType.object : EntityTags.EntityTagValueType.literal);
        }
    }
}

