/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.elasticsearch.model;

import com.google.common.collect.ImmutableMap;
import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.clouddriver.elasticsearch.model.ElasticSearchEntityTagsProvider;
import com.netflix.spinnaker.clouddriver.model.EntityTags;
import com.netflix.spinnaker.clouddriver.model.ServerGroupProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ElasticSearchEntityTagsReconciler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Front50Service front50Service;
    private final Map<String, ServerGroupProvider> serverGroupProviderByCloudProvider = new HashMap<String, ServerGroupProvider>();

    @Autowired
    public ElasticSearchEntityTagsReconciler(Front50Service front50Service, Optional<Collection<ServerGroupProvider>> serverGroupProviders) {
        this.front50Service = front50Service;
        for (ServerGroupProvider serverGroupProvider : (Collection)serverGroupProviders.orElse(new ArrayList())) {
            this.serverGroupProviderByCloudProvider.put(serverGroupProvider.getCloudProviderId(), serverGroupProvider);
        }
    }

    Map reconcile(ElasticSearchEntityTagsProvider entityTagsProvider, String cloudProvider, String account, String region, boolean dryRun) {
        Collection allEntityTags = this.front50Service.getAllEntityTags(false);
        List<EntityTags> allServerGroupEntityTags = this.filter(allEntityTags, cloudProvider, account, region);
        List<EntityTags> existingServerGroupEntityTags = this.filter(Collections.singletonList(cloudProvider), allServerGroupEntityTags);
        this.log.debug("Found {} server group entity tags (valid: {}, invalid: {}, dryRun: {})", new Object[]{allServerGroupEntityTags.size(), existingServerGroupEntityTags.size(), allServerGroupEntityTags.size() - existingServerGroupEntityTags.size(), dryRun});
        ArrayList<EntityTags> orphanedServerGroupEntityTags = new ArrayList<EntityTags>(allServerGroupEntityTags);
        orphanedServerGroupEntityTags.removeAll(existingServerGroupEntityTags);
        if (!dryRun) {
            entityTagsProvider.bulkDelete(orphanedServerGroupEntityTags);
            this.log.info("Removed {} orphaned entity tags", (Object)orphanedServerGroupEntityTags.size());
        }
        return ImmutableMap.builder().put((Object)"dryRun", (Object)dryRun).put((Object)"orphanCount", (Object)orphanedServerGroupEntityTags.size()).build();
    }

    public List<EntityTags> filter(Collection<EntityTags> entityTags) {
        return this.filter(this.serverGroupProviderByCloudProvider.keySet(), entityTags);
    }

    private List<EntityTags> filter(Collection<String> cloudProviders, Collection<EntityTags> entityTags) {
        Set serverGroupIdentifiers = this.serverGroupProviderByCloudProvider.values().stream().filter((? super T p) -> cloudProviders.contains(p.getCloudProviderId())).flatMap(p -> p.getServerGroupIdentifiers(null, null).stream()).map(String::toLowerCase).collect(Collectors.toSet());
        Set missingServerGroupEntityTags = entityTags.stream().filter((? super T e) -> e.getEntityRef() != null).filter((? super T e) -> cloudProviders.contains(e.getEntityRef().getCloudProvider())).filter((? super T e) -> "servergroup".equalsIgnoreCase(e.getEntityRef().getEntityType())).filter((? super T e) -> !serverGroupIdentifiers.contains(this.buildServerGroupIdentifier(e.getEntityRef()))).map(EntityTags::getId).collect(Collectors.toSet());
        return entityTags.stream().filter((? super T e) -> !missingServerGroupEntityTags.contains(e.getId())).collect(Collectors.toList());
    }

    private List<EntityTags> filter(Collection<EntityTags> entityTags, String cloudProvider, String account, String region) {
        return entityTags.stream().filter((? super T e) -> e.getEntityRef() != null).filter((? super T e) -> "servergroup".equalsIgnoreCase(e.getEntityRef().getEntityType())).filter((? super T e) -> cloudProvider.equalsIgnoreCase(e.getEntityRef().getCloudProvider())).filter((? super T e) -> account == null || account.equalsIgnoreCase(e.getEntityRef().getAccount())).filter((? super T e) -> region == null || region.equalsIgnoreCase(e.getEntityRef().getRegion())).filter((? super T e) -> e.getLastModified() < System.currentTimeMillis() - TimeUnit.DAYS.toMillis(14L)).collect(Collectors.toList());
    }

    private String buildServerGroupIdentifier(EntityTags.EntityRef entityRef) {
        ServerGroupProvider serverGroupProvider = this.serverGroupProviderByCloudProvider.get(entityRef.getCloudProvider());
        return serverGroupProvider.buildServerGroupIdentifier(entityRef.getAccount(), entityRef.getRegion(), entityRef.getEntityId()).toLowerCase();
    }
}

