/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.elasticsearch.ops;

import com.google.common.collect.Lists;
import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.elasticsearch.EntityRefIdBuilder;
import com.netflix.spinnaker.clouddriver.elasticsearch.descriptions.BulkUpsertEntityTagsDescription;
import com.netflix.spinnaker.clouddriver.elasticsearch.model.ElasticSearchEntityTagsProvider;
import com.netflix.spinnaker.clouddriver.elasticsearch.ops.BulkUpsertEntityTagsAtomicOperationResult;
import com.netflix.spinnaker.clouddriver.model.EntityTags;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.security.AccountCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkUpsertEntityTagsAtomicOperation
implements AtomicOperation<BulkUpsertEntityTagsAtomicOperationResult> {
    private static final Logger log = LoggerFactory.getLogger(BulkUpsertEntityTagsAtomicOperation.class);
    private static final String BASE_PHASE = "ENTITY_TAGS";
    private final RetrySupport retrySupport;
    private final Front50Service front50Service;
    private final AccountCredentialsProvider accountCredentialsProvider;
    private final ElasticSearchEntityTagsProvider entityTagsProvider;
    private final BulkUpsertEntityTagsDescription bulkUpsertEntityTagsDescription;

    public BulkUpsertEntityTagsAtomicOperation(RetrySupport retrySupport, Front50Service front50Service, AccountCredentialsProvider accountCredentialsProvider, ElasticSearchEntityTagsProvider entityTagsProvider, BulkUpsertEntityTagsDescription bulkUpsertEntityTagsDescription) {
        this.retrySupport = retrySupport;
        this.front50Service = front50Service;
        this.accountCredentialsProvider = accountCredentialsProvider;
        this.entityTagsProvider = entityTagsProvider;
        this.bulkUpsertEntityTagsDescription = bulkUpsertEntityTagsDescription;
    }

    public BulkUpsertEntityTagsAtomicOperationResult operate(List priorOutputs) {
        BulkUpsertEntityTagsAtomicOperationResult result = new BulkUpsertEntityTagsAtomicOperationResult();
        this.bulkUpsertEntityTagsDescription.entityTags = this.bulkUpsertEntityTagsDescription.entityTags != null ? new ArrayList<EntityTags>(this.bulkUpsertEntityTagsDescription.entityTags) : new ArrayList<EntityTags>();
        List<EntityTags> entityTags = this.bulkUpsertEntityTagsDescription.entityTags;
        this.addTagIdsIfMissing(entityTags, result);
        BulkUpsertEntityTagsAtomicOperation.mergeTags(this.bulkUpsertEntityTagsDescription);
        Date now = new Date();
        Lists.partition(entityTags, (int)50).forEach(tags -> {
            BulkUpsertEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, "Retrieving current entity tags");
            Map<String, EntityTags> existingTags = this.retrieveExistingTags((List<EntityTags>)tags);
            ArrayList<EntityTags> modifiedEntityTags = new ArrayList<EntityTags>();
            BulkUpsertEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, "Merging existing tags and metadata");
            tags.forEach(tag -> {
                boolean wasModified = BulkUpsertEntityTagsAtomicOperation.mergeExistingTagsAndMetadata(now, (EntityTags)existingTags.get(tag.getId()), tag, this.bulkUpsertEntityTagsDescription.isPartial);
                if (wasModified) {
                    modifiedEntityTags.add((EntityTags)tag);
                }
            });
            if (modifiedEntityTags.isEmpty()) {
                BulkUpsertEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, "No tags have been modified");
                return;
            }
            BulkUpsertEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, "Performing batch update to durable tagging service");
            Map<String, EntityTags> durableTags = this.front50Service.batchUpdate(new ArrayList(modifiedEntityTags)).stream().collect(Collectors.toMap(EntityTags::getId, Function.identity()));
            BulkUpsertEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, "Pushing tags to Elastic Search");
            this.updateMetadataFromDurableTagsAndIndex(modifiedEntityTags, durableTags, result);
            result.upserted.addAll(modifiedEntityTags);
        });
        return result;
    }

    private Map<String, EntityTags> retrieveExistingTags(List<EntityTags> entityTags) {
        List ids = entityTags.stream().map(EntityTags::getId).collect(Collectors.toList());
        try {
            return (Map)this.retrySupport.retry(() -> this.front50Service.getAllEntityTagsById(ids).stream().collect(Collectors.toMap(EntityTags::getId, Function.identity())), 10, 2000L, false);
        }
        catch (Exception e) {
            log.error("Unable to retrieve existing tags from Front50, reason: {} (ids: {})", (Object)e.getMessage(), ids);
            throw e;
        }
    }

    private void addTagIdsIfMissing(List<EntityTags> entityTags, BulkUpsertEntityTagsAtomicOperationResult result) {
        ArrayList failed = new ArrayList();
        entityTags.forEach(tag -> {
            if (tag.getId() == null) {
                try {
                    EntityRefIdBuilder.EntityRefId entityRefId = BulkUpsertEntityTagsAtomicOperation.entityRefId(this.accountCredentialsProvider, tag);
                    tag.setId(entityRefId.id);
                    tag.setIdPattern(entityRefId.idPattern);
                }
                catch (Exception e) {
                    log.error("Failed to build tag id for {}", (Object)tag.getId(), (Object)e);
                    BulkUpsertEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Failed to build tag id for %s, reason: %s", tag.getId(), e.getMessage()));
                    failed.add(tag);
                    result.failures.add(new BulkUpsertEntityTagsAtomicOperationResult.UpsertFailureResult((EntityTags)tag, e));
                }
            }
        });
        entityTags.removeAll(failed);
    }

    private void updateMetadataFromDurableTagsAndIndex(List<EntityTags> entityTags, Map<String, EntityTags> durableTags, BulkUpsertEntityTagsAtomicOperationResult result) {
        ArrayList failed = new ArrayList();
        entityTags.forEach(tag -> {
            try {
                EntityTags durableTag = (EntityTags)durableTags.get(tag.getId());
                tag.setLastModified(durableTag.getLastModified());
                tag.setLastModifiedBy(durableTag.getLastModifiedBy());
            }
            catch (Exception e) {
                log.error("Failed to update {} in ElasticSearch", (Object)tag.getId(), (Object)e);
                BulkUpsertEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Failed to update %s in ElasticSearch, reason: %s", tag.getId(), e.getMessage()));
                failed.add(tag);
                result.failures.add(new BulkUpsertEntityTagsAtomicOperationResult.UpsertFailureResult((EntityTags)tag, e));
            }
        });
        entityTags.removeAll(failed);
        BulkUpsertEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, "Indexing tags in ElasticSearch");
        this.entityTagsProvider.bulkIndex(entityTags);
        entityTags.forEach(tag -> {
            try {
                this.entityTagsProvider.verifyIndex((EntityTags)tag);
            }
            catch (Exception e) {
                log.error("Failed to verify {} in ElasticSearch", (Object)tag.getId(), (Object)e);
                BulkUpsertEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Failed to verify %s in ElasticSearch, reason: %s", tag.getId(), e.getMessage()));
                failed.add(tag);
            }
        });
        entityTags.removeAll(failed);
    }

    public static EntityRefIdBuilder.EntityRefId entityRefId(AccountCredentialsProvider accountCredentialsProvider, EntityTags description) {
        AccountCredentials accountCredentials;
        EntityTags.EntityRef entityRef = description.getEntityRef();
        String entityRefAccount = entityRef.getAccount();
        String entityRefAccountId = entityRef.getAccountId();
        if (entityRefAccount != null && !entityRefAccount.equals("*") && entityRefAccountId == null) {
            accountCredentials = BulkUpsertEntityTagsAtomicOperation.lookupAccountCredentialsByAccountIdOrName(accountCredentialsProvider, entityRefAccount, "accountName");
            entityRefAccountId = accountCredentials.getAccountId();
            entityRef.setAccountId(entityRefAccountId);
        }
        if (entityRefAccount == null && entityRefAccountId != null && (accountCredentials = BulkUpsertEntityTagsAtomicOperation.lookupAccountCredentialsByAccountIdOrName(accountCredentialsProvider, entityRefAccountId, "accountId")) != null) {
            entityRefAccount = accountCredentials.getName();
            entityRef.setAccount(entityRefAccount);
        }
        return EntityRefIdBuilder.buildId(entityRef.getCloudProvider(), entityRef.getEntityType(), entityRef.getEntityId(), Optional.ofNullable(entityRefAccountId).orElse(entityRefAccount), entityRef.getRegion());
    }

    public static boolean mergeExistingTagsAndMetadata(Date now, EntityTags currentTags, EntityTags updatedTags, boolean isPartial) {
        boolean wasModified;
        if (currentTags == null) {
            BulkUpsertEntityTagsAtomicOperation.addTagMetadata(now, updatedTags);
            return true;
        }
        boolean bl = wasModified = !BulkUpsertEntityTagsAtomicOperation.containedWithin(currentTags, updatedTags);
        if (!isPartial) {
            wasModified = wasModified || !BulkUpsertEntityTagsAtomicOperation.containedWithin(updatedTags, currentTags);
            BulkUpsertEntityTagsAtomicOperation.replaceTagContents(currentTags, updatedTags);
        }
        updatedTags.setTagsMetadata(currentTags.getTagsMetadata() == null ? new ArrayList() : currentTags.getTagsMetadata());
        updatedTags.getTags().forEach(tag -> updatedTags.putEntityTagMetadata(BulkUpsertEntityTagsAtomicOperation.tagMetadata(tag, now)));
        currentTags.getTags().forEach(arg_0 -> ((EntityTags)updatedTags).putEntityTagIfAbsent(arg_0));
        return wasModified;
    }

    private static boolean containedWithin(EntityTags source, EntityTags target) {
        return target.getTags().stream().allMatch(updatedTag -> source.getTags().stream().anyMatch(currentTag -> currentTag.getName().equals(updatedTag.getName()) && currentTag.getValue().equals(updatedTag.getValue())));
    }

    private static void mergeTags(BulkUpsertEntityTagsDescription bulkUpsertEntityTagsDescription) {
        ArrayList toRemove = new ArrayList();
        bulkUpsertEntityTagsDescription.entityTags.forEach(tag -> {
            Collection matches = bulkUpsertEntityTagsDescription.entityTags.stream().filter(t -> t.getId().equals(tag.getId()) && !toRemove.contains(t) && !tag.equals(t)).collect(Collectors.toList());
            if (matches.size() > 1) {
                matches.forEach(m -> tag.getTags().addAll(m.getTags()));
                toRemove.addAll(matches);
            }
        });
        bulkUpsertEntityTagsDescription.entityTags.removeAll(toRemove);
    }

    private static void replaceTagContents(EntityTags currentTags, EntityTags entityTagsDescription) {
        Map<String, EntityTags.EntityTag> entityTagsByName = entityTagsDescription.getTags().stream().collect(Collectors.toMap(EntityTags.EntityTag::getName, x -> x));
        currentTags.setTags(entityTagsDescription.getTags());
        for (EntityTags.EntityTagMetadata entityTagMetadata : currentTags.getTagsMetadata()) {
            if (entityTagsByName.containsKey(entityTagMetadata.getName())) continue;
            currentTags.removeEntityTagMetadata(entityTagMetadata.getName());
        }
    }

    private static EntityTags.EntityTagMetadata tagMetadata(EntityTags.EntityTag entityTag, Date now) {
        String user = AuthenticatedRequest.getSpinnakerUser().orElse("unknown");
        String tagName = entityTag.getName();
        if (entityTag.getTimestamp() != null) {
            now = new Date(entityTag.getTimestamp());
        }
        EntityTags.EntityTagMetadata metadata = new EntityTags.EntityTagMetadata();
        metadata.setName(tagName);
        metadata.setCreated(Long.valueOf(now.getTime()));
        metadata.setLastModified(Long.valueOf(now.getTime()));
        metadata.setCreatedBy(user);
        metadata.setLastModifiedBy(user);
        return metadata;
    }

    private static void addTagMetadata(Date now, EntityTags entityTags) {
        entityTags.setTagsMetadata(new ArrayList());
        entityTags.getTags().forEach(tag -> entityTags.putEntityTagMetadata(BulkUpsertEntityTagsAtomicOperation.tagMetadata(tag, now)));
    }

    private static AccountCredentials lookupAccountCredentialsByAccountIdOrName(AccountCredentialsProvider accountCredentialsProvider, String entityRefAccountIdOrName, String type) {
        return accountCredentialsProvider.getAll().stream().filter(c -> entityRefAccountIdOrName.equals(c.getAccountId()) || entityRefAccountIdOrName.equals(c.getName())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("No credentials found for %s: %s", type, entityRefAccountIdOrName)));
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }
}

