/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.elasticsearch.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.clouddriver.elasticsearch.model.ElasticSearchEntityTagsReconciler;
import com.netflix.spinnaker.clouddriver.elasticsearch.model.ElasticSearchException;
import com.netflix.spinnaker.clouddriver.helpers.OperationPoller;
import com.netflix.spinnaker.clouddriver.model.EntityTags;
import com.netflix.spinnaker.clouddriver.model.EntityTagsProvider;
import com.netflix.spinnaker.config.ElasticSearchConfigProperties;
import com.netflix.spinnaker.kork.core.RetrySupport;
import com.netflix.spinnaker.security.AuthenticatedRequest;
import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.Bulk;
import io.searchbox.core.ClearScroll;
import io.searchbox.core.Delete;
import io.searchbox.core.Index;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.SearchScroll;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.DeleteIndex;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ElasticSearchEntityTagsProvider
implements EntityTagsProvider {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchEntityTagsProvider.class);
    private final ApplicationContext applicationContext;
    private final RetrySupport retrySupport;
    private final ObjectMapper objectMapper;
    private final Front50Service front50Service;
    private final JestClient jestClient;
    private final String activeElasticSearchIndex;
    private final String mappingTypeName;

    @Autowired
    public ElasticSearchEntityTagsProvider(ApplicationContext applicationContext, RetrySupport retrySupport, ObjectMapper objectMapper, Front50Service front50Service, JestClient jestClient, ElasticSearchConfigProperties elasticSearchConfigProperties) {
        this.applicationContext = applicationContext;
        this.retrySupport = retrySupport;
        this.objectMapper = objectMapper;
        this.front50Service = front50Service;
        this.jestClient = jestClient;
        this.activeElasticSearchIndex = elasticSearchConfigProperties.getActiveIndex();
        this.mappingTypeName = elasticSearchConfigProperties.getMappingTypeName();
    }

    public Collection<EntityTags> getAll(String cloudProvider, String application, String entityType, List<String> entityIds, String idPrefix, String account, String region, String namespace, Map<String, Object> tags, int maxResults) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (cloudProvider != null) {
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"entityRef.cloudProvider", (String)cloudProvider));
        }
        if (application != null) {
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"entityRef.application", (String)application));
        }
        if (entityIds != null && !entityIds.isEmpty()) {
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"entityRef.entityId", entityIds));
        }
        if (account != null) {
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"entityRef.account", (String)account));
        }
        if (region != null) {
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"entityRef.region", (String)region));
        }
        if (idPrefix != null) {
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"id", (String)idPrefix));
        }
        if (entityType != null) {
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"entityRef.entityType", (String)entityType.toLowerCase()));
        }
        if (tags != null) {
            for (Map.Entry<String, Object> entry : tags.entrySet()) {
                queryBuilder = queryBuilder.must(this.applyTagsToBuilder(namespace, Collections.singletonMap(entry.getKey(), entry.getValue())));
            }
        }
        if ((tags == null || tags.isEmpty()) && namespace != null) {
            queryBuilder = queryBuilder.must(this.applyTagsToBuilder(namespace, Collections.emptyMap()));
        }
        return this.search((QueryBuilder)queryBuilder, maxResults);
    }

    public Optional<EntityTags> get(String id) {
        return this.get(id, Collections.emptyMap());
    }

    public Optional<EntityTags> get(String id, Map<String, Object> tags) {
        List<EntityTags> entityTags;
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"_id", (Object)id));
        if (tags != null) {
            for (Map.Entry<String, Object> entry : tags.entrySet()) {
                queryBuilder = queryBuilder.must(this.applyTagsToBuilder(null, Collections.singletonMap(entry.getKey(), entry.getValue())));
            }
        }
        return (entityTags = this.search((QueryBuilder)queryBuilder, 1)).isEmpty() ? Optional.empty() : Optional.of(entityTags.get(0));
    }

    public void index(EntityTags entityTags) {
        try {
            Index action = ((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder(this.objectMapper.convertValue((Object)ElasticSearchEntityTagsProvider.prepareForWrite(this.objectMapper, entityTags), Map.class)).index(this.activeElasticSearchIndex)).type(this.mappingTypeName)).id(URLEncoder.encode(entityTags.getId(), "UTF-8"))).build();
            JestResult jestResult = this.jestClient.execute((Action)action);
            if (!jestResult.isSucceeded()) {
                throw new ElasticSearchException(String.format("Failed to index %s, reason: '%s'", entityTags.getId(), jestResult.getErrorMessage()));
            }
        }
        catch (IOException e) {
            throw new ElasticSearchException(String.format("Failed to index %s, reason: '%s'", entityTags.getId(), e.getMessage()));
        }
    }

    public void bulkIndex(Collection<EntityTags> multipleEntityTags) {
        Lists.partition(new ArrayList<EntityTags>(multipleEntityTags), (int)1000).forEach(tags -> {
            Bulk.Builder builder = new Bulk.Builder().defaultIndex(this.activeElasticSearchIndex);
            for (EntityTags entityTags : tags) {
                Map tag = (Map)this.objectMapper.convertValue((Object)ElasticSearchEntityTagsProvider.prepareForWrite(this.objectMapper, entityTags), Map.class);
                builder = builder.addAction((BulkableAction)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)tag).index(this.activeElasticSearchIndex)).type(this.mappingTypeName)).id(entityTags.getId())).build());
            }
            Bulk bulk = builder.build();
            this.retrySupport.retry(() -> {
                try {
                    JestResult jestResult = this.jestClient.execute((Action)bulk);
                    if (!jestResult.isSucceeded()) {
                        throw new ElasticSearchException(String.format("Failed to index bulk entity tags, reason: '%s'", jestResult.getErrorMessage()));
                    }
                    return true;
                }
                catch (IOException e) {
                    String message = String.format("Failed to index bulk entity tags, reason: '%s'", e.getMessage());
                    log.error(message + " ... retrying!");
                    throw new ElasticSearchException(message);
                }
            }, 5, 1000L, false);
        });
    }

    public void delete(String id) {
        try {
            EntityTags entityTags = this.get(id).orElse(null);
            if (entityTags == null) {
                return;
            }
            Delete action = ((Delete.Builder)((Delete.Builder)new Delete.Builder(id).index(this.activeElasticSearchIndex)).type(this.mappingTypeName)).build();
            JestResult jestResult = this.jestClient.execute((Action)action);
            if (!jestResult.isSucceeded()) {
                throw new ElasticSearchException(String.format("Failed to delete %s, reason: '%s'", id, jestResult.getErrorMessage()));
            }
        }
        catch (IOException e) {
            throw new ElasticSearchException(String.format("Failed to delete %s, reason: '%s'", id, e.getMessage()));
        }
    }

    public void bulkDelete(Collection<EntityTags> multipleEntityTags) {
        Lists.partition(new ArrayList<EntityTags>(multipleEntityTags), (int)1000).forEach(tags -> {
            Bulk.Builder builder = new Bulk.Builder().defaultIndex(this.activeElasticSearchIndex);
            for (EntityTags entityTags : tags) {
                builder = builder.addAction((BulkableAction)((Delete.Builder)new Delete.Builder(entityTags.getId()).type(this.mappingTypeName)).build());
            }
            Bulk bulk = builder.build();
            try {
                JestResult jestResult = this.jestClient.execute((Action)bulk);
                if (!jestResult.isSucceeded()) {
                    throw new ElasticSearchException(String.format("Failed to bulk delete entity tags, reason: '%s'", jestResult.getErrorMessage()));
                }
            }
            catch (IOException e) {
                throw new ElasticSearchException(String.format("Failed to bulk delete entity tags, reason: '%s'", e.getMessage()));
            }
        });
    }

    public void reindex() {
        try {
            log.info("Deleting Index {}", (Object)this.activeElasticSearchIndex);
            this.jestClient.execute((Action)new DeleteIndex.Builder(this.activeElasticSearchIndex).build());
            log.info("Deleted Index {}", (Object)this.activeElasticSearchIndex);
            log.info("Creating Index {}", (Object)this.activeElasticSearchIndex);
            this.jestClient.execute((Action)new CreateIndex.Builder(this.activeElasticSearchIndex).build());
            log.info("Created Index {}", (Object)this.activeElasticSearchIndex);
        }
        catch (IOException e2) {
            throw new ElasticSearchException("Unable to re-create index '" + this.activeElasticSearchIndex + "'");
        }
        Collection entityTags = this.front50Service.getAllEntityTags(true);
        List<EntityTags> filteredEntityTags = this.getElasticSearchEntityTagsReconciler().filter(entityTags);
        log.info("Indexing {} entity tags ({} orphans have been excluded)", (Object)filteredEntityTags.size(), (Object)(entityTags.size() - filteredEntityTags.size()));
        this.bulkIndex(filteredEntityTags.stream().filter(e -> e.getEntityRef() != null).collect(Collectors.toList()));
        log.info("Indexed {} entity tags", (Object)filteredEntityTags.size());
    }

    public Map delta() {
        Collection allEntityTagsFront50 = this.front50Service.getAllEntityTags(false);
        Map<String, List<EntityTags>> entityTagsByEntityTypeFront50 = allEntityTagsFront50.stream().collect(Collectors.groupingBy(e -> Optional.ofNullable(Optional.ofNullable(e.getEntityRef()).orElse(new EntityTags.EntityRef()).getEntityType()).orElse("unknown")));
        HashMap entityTagsByEntityTypeElasticsearch = new HashMap();
        entityTagsByEntityTypeFront50.keySet().forEach(entityType -> {
            BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
            queryBuilder = queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"entityRef.entityType", (String)entityType));
            entityTagsByEntityTypeElasticsearch.put(entityType, this.fetchAll((QueryBuilder)queryBuilder, 5000, "2m"));
        });
        HashMap metadata = new HashMap();
        entityTagsByEntityTypeFront50.keySet().forEach(entityType -> {
            HashMap<String, Object> entityTypeMetadata = new HashMap<String, Object>();
            metadata.put(entityType, entityTypeMetadata);
            Set entityIdsFront50 = ((List)entityTagsByEntityTypeFront50.get(entityType)).stream().map(EntityTags::getId).collect(Collectors.toSet());
            Set entityIdsElasticsearch = ((List)entityTagsByEntityTypeElasticsearch.get(entityType)).stream().map(EntityTags::getId).collect(Collectors.toSet());
            entityTypeMetadata.put("front50_count", entityIdsFront50.size());
            entityTypeMetadata.put("elasticsearch_count", entityIdsElasticsearch.size());
            if (!entityIdsFront50.equals(entityIdsElasticsearch)) {
                Set entityIdsMissingInFront50 = entityIdsElasticsearch.stream().filter(e -> !entityIdsFront50.contains(e)).collect(Collectors.toSet());
                Set entityIdsMissingInElasticsearch = entityIdsFront50.stream().filter(e -> !entityIdsElasticsearch.contains(e)).collect(Collectors.toSet());
                log.warn("'{}' missing in Front50 ({}) {}", new Object[]{entityType, entityIdsMissingInFront50.size(), entityIdsMissingInFront50});
                log.warn("'{}' missing in Elasticsearch ({}) {}", new Object[]{entityType, entityIdsMissingInElasticsearch.size(), entityIdsMissingInElasticsearch});
                entityTypeMetadata.put("front50_missing", entityIdsMissingInFront50);
                entityTypeMetadata.put("front50_missing_count", entityIdsMissingInFront50.size());
                entityTypeMetadata.put("elasticsearch_missing", entityIdsMissingInElasticsearch);
                entityTypeMetadata.put("elasticsearch_missing_count", entityIdsMissingInElasticsearch.size());
            }
        });
        return metadata;
    }

    public void verifyIndex(EntityTags entityTags) {
        OperationPoller.retryWithBackoff(o -> {
            HashMap<String, Object> entityTagsCriteria = new HashMap<String, Object>();
            entityTags.getTags().stream().filter(entityTag -> entityTag != null && entityTag.getValueType() != null).forEach(entityTag -> {
                switch (entityTag.getValueType()) {
                    case object: {
                        entityTagsCriteria.put(entityTag.getName(), "*");
                        break;
                    }
                    default: {
                        entityTagsCriteria.put(entityTag.getName(), entityTag.getValueForRead(this.objectMapper));
                    }
                }
            });
            if (!this.get(entityTags.getId(), entityTagsCriteria).isPresent()) {
                throw new ElasticSearchException(String.format("Failed to index %s, reason: 'no document found with id'", entityTags.getId()));
            }
            return true;
        }, (long)1000L, (int)3);
    }

    public Map reconcile(String cloudProvider, String account, String region, boolean dryRun) {
        return this.getElasticSearchEntityTagsReconciler().reconcile(this, cloudProvider, account, region, dryRun);
    }

    public Map<String, Object> deleteByNamespace(String namespace, boolean dryRun, boolean deleteFromSource) {
        final List<EntityTags> entityTagsForNamespace = this.getAllMatchingEntityTags(namespace, null);
        for (EntityTags entityTags2 : entityTagsForNamespace) {
            entityTags2.setTags((Collection)entityTags2.getTags().stream().filter(e -> !namespace.equalsIgnoreCase(e.getNamespace())).collect(Collectors.toList()));
            Set tagNames = entityTags2.getTags().stream().map(e -> e.getName().toLowerCase()).collect(Collectors.toSet());
            entityTags2.setTagsMetadata((Collection)entityTags2.getTagsMetadata().stream().filter(e -> tagNames.contains(e.getName().toLowerCase())).collect(Collectors.toList()));
        }
        HashMap results = new HashMap(){
            {
                this.put("affectedIds", entityTagsForNamespace.stream().map(EntityTags::getId).collect(Collectors.toList()));
                this.put("deletedFromSource", false);
                this.put("deletedFromElasticsearch", false);
            }
        };
        if (!dryRun) {
            this.bulkIndex(entityTagsForNamespace);
            results.put("deletedFromElasticsearch", true);
            if (deleteFromSource) {
                ExecutorService executor = Executors.newFixedThreadPool(6, new ThreadFactoryBuilder().setNameFormat(ElasticSearchEntityTagsProvider.class.getSimpleName() + "-%d").build());
                AtomicLong countProcessed = new AtomicLong();
                Lists.partition(entityTagsForNamespace, (int)50).forEach(entityTags -> executor.submit(() -> {
                    try {
                        AuthenticatedRequest.allowAnonymous(() -> this.front50Service.batchUpdate((Collection)entityTags));
                        log.info("Deleted {} out of {} tags in namespace {}", new Object[]{countProcessed.addAndGet(entityTags.size()), entityTagsForNamespace.size(), namespace});
                    }
                    catch (Exception e) {
                        log.error("Failed to delete a batch of tags from front50 in namespace {}", (Object)namespace, (Object)e);
                    }
                }));
                try {
                    executor.shutdown();
                    executor.awaitTermination(15L, TimeUnit.MINUTES);
                    results.put("deletedFromSource", true);
                }
                catch (InterruptedException e2) {
                    String error = String.format("Failed to bulk remove tags from front50 in namespace %s due to timeout, please try again", namespace);
                    log.error(error, (Throwable)e2);
                    results.put("error", error);
                    results.put("exception", e2);
                }
            }
        }
        return results;
    }

    public Map<String, Object> deleteByTag(String tag, boolean dryRun, boolean deleteFromSource) {
        final List<EntityTags> entityTagsForTag = this.getAllMatchingEntityTags(null, tag);
        for (EntityTags entityTags : entityTagsForTag) {
            entityTags.setTags((Collection)entityTags.getTags().stream().filter(e -> !tag.equalsIgnoreCase(e.getName())).collect(Collectors.toList()));
            Set tagNames = entityTags.getTags().stream().map(e -> e.getName().toLowerCase()).collect(Collectors.toSet());
            entityTags.setTagsMetadata((Collection)entityTags.getTagsMetadata().stream().filter(e -> tagNames.contains(e.getName().toLowerCase())).collect(Collectors.toList()));
        }
        HashMap results = new HashMap(){
            {
                this.put("affectedIds", entityTagsForTag.stream().map(EntityTags::getId).collect(Collectors.toList()));
                this.put("deletedFromSource", false);
                this.put("deletedFromElasticsearch", false);
            }
        };
        if (!dryRun) {
            this.bulkIndex(entityTagsForTag);
            results.put("deletedFromElasticsearch", true);
            if (deleteFromSource) {
                Lists.partition(entityTagsForTag, (int)50).forEach(arg_0 -> ((Front50Service)this.front50Service).batchUpdate(arg_0));
                results.put("deletedFromSource", true);
            }
        }
        return results;
    }

    private List<EntityTags> getAllMatchingEntityTags(String namespace, String tag) {
        BoolQueryBuilder queryBuilder;
        HashSet entityTagsIdentifiers = new HashSet();
        List<EntityTags> entityTagsForTag = this.front50Service.getAllEntityTags(false).stream().filter(e -> e.getTags().stream().anyMatch(t -> namespace != null && namespace.equalsIgnoreCase(t.getNamespace()) || tag != null && tag.equalsIgnoreCase(t.getName()))).collect(Collectors.toList());
        entityTagsIdentifiers.addAll(entityTagsForTag.stream().map(e -> e.getId().toLowerCase()).collect(Collectors.toSet()));
        if (tag != null) {
            queryBuilder = QueryBuilders.boolQuery().must(this.applyTagsToBuilder(null, Collections.singletonMap(tag, "*")));
            this.fetchAll((QueryBuilder)queryBuilder, 5000, "2m").forEach(entityTags -> {
                if (!entityTagsIdentifiers.contains(entityTags.getId())) {
                    entityTagsForTag.add((EntityTags)entityTags);
                    entityTagsIdentifiers.add(entityTags.getId().toLowerCase());
                }
            });
        }
        if (namespace != null) {
            queryBuilder = QueryBuilders.boolQuery().must(this.applyTagsToBuilder(namespace, Collections.emptyMap()));
            this.fetchAll((QueryBuilder)queryBuilder, 5000, "2m").forEach(entityTags -> {
                if (!entityTagsIdentifiers.contains(entityTags.getId())) {
                    entityTagsForTag.add((EntityTags)entityTags);
                    entityTagsIdentifiers.add(entityTags.getId().toLowerCase());
                }
            });
        }
        return entityTagsForTag;
    }

    private QueryBuilder applyTagsToBuilder(String namespace, Map<String, Object> tags) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (tags != null && !tags.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.flatten(new HashMap<String, Object>(), null, tags).entrySet()) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tags.name", (String)entry.getKey()));
                if (entry.getValue().equals("*")) continue;
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"tags.value", (Object)entry.getValue()));
            }
        }
        if (namespace != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tags.namespace", (String)namespace));
        }
        return QueryBuilders.nestedQuery((String)"tags", (QueryBuilder)boolQueryBuilder, (ScoreMode)ScoreMode.Avg);
    }

    private Map<String, Object> flatten(Map<String, Object> accumulator, String rootKey, Map<String, Object> criteria) {
        criteria.forEach((k, v) -> {
            if (v instanceof Map) {
                this.flatten(accumulator, rootKey == null ? k : rootKey + "." + k, (Map)v);
            } else {
                accumulator.put(rootKey == null ? k : rootKey + "." + k, v);
            }
        });
        return accumulator;
    }

    private List<EntityTags> search(QueryBuilder queryBuilder, int maxResults) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(queryBuilder).size(maxResults);
        String searchQuery = searchSourceBuilder.toString();
        Search.Builder searchBuilder = (Search.Builder)new Search.Builder(searchQuery).addIndex(this.activeElasticSearchIndex);
        try {
            SearchResult searchResult = (SearchResult)this.jestClient.execute((Action)searchBuilder.build());
            return searchResult.getHits(Map.class).stream().map(h -> (Map)h.source).map(s -> ElasticSearchEntityTagsProvider.prepareForRead(this.objectMapper, s)).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EntityTags> fetchAll(QueryBuilder queryBuilder, int scrollSize, String scrollTime) {
        JestResult result;
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(queryBuilder);
        Search.Builder builder = (Search.Builder)new Search.Builder(searchSourceBuilder.toString()).addIndex(this.activeElasticSearchIndex);
        Search search = ((Search.Builder)((Search.Builder)builder.setParameter("size", (Object)scrollSize)).setParameter("scroll", (Object)scrollTime)).build();
        ArrayList<EntityTags> allEntityTags = new ArrayList<EntityTags>();
        try {
            result = this.jestClient.execute((Action)search);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List entityTags = result.getSourceAsObjectList(EntityTags.class);
        allEntityTags.addAll(entityTags);
        String scrollId = result.getJsonObject().get("_scroll_id").getAsString();
        try {
            while (entityTags.size() > 0) {
                SearchScroll scroll = new SearchScroll.Builder(scrollId, scrollTime).build();
                try {
                    result = this.jestClient.execute((Action)scroll);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                entityTags = result.getSourceAsObjectList(EntityTags.class);
                allEntityTags.addAll(entityTags);
                scrollId = result.getJsonObject().getAsJsonPrimitive("_scroll_id").getAsString();
            }
            ArrayList<EntityTags> arrayList = allEntityTags;
            return arrayList;
        }
        finally {
            try {
                this.jestClient.execute((Action)new ClearScroll.Builder().addScrollId(scrollId).build());
            }
            catch (IOException e) {
                log.warn("Unable to clear scroll id {}", (Object)scrollId, (Object)e);
            }
        }
    }

    private ElasticSearchEntityTagsReconciler getElasticSearchEntityTagsReconciler() {
        return (ElasticSearchEntityTagsReconciler)this.applicationContext.getBean(ElasticSearchEntityTagsReconciler.class);
    }

    private static EntityTags prepareForWrite(ObjectMapper objectMapper, EntityTags entityTags) {
        EntityTags copyOfEntityTags = (EntityTags)objectMapper.convertValue(objectMapper.convertValue((Object)entityTags, Map.class), EntityTags.class);
        copyOfEntityTags.getTags().forEach(entityTag -> entityTag.setValue(entityTag.getValueForWrite(objectMapper)));
        String application = copyOfEntityTags.getEntityRef().getApplication();
        if (application == null || application.trim().isEmpty()) {
            try {
                Names names = Names.parseName((String)copyOfEntityTags.getEntityRef().getEntityId());
                copyOfEntityTags.getEntityRef().setApplication(names.getApp());
            }
            catch (Exception e) {
                log.error("Unable to extract application name (entityId: {})", (Object)copyOfEntityTags.getEntityRef().getEntityId(), (Object)e);
            }
        }
        return copyOfEntityTags;
    }

    private static EntityTags prepareForRead(ObjectMapper objectMapper, Map indexedEntityTags) {
        EntityTags entityTags = (EntityTags)objectMapper.convertValue((Object)indexedEntityTags, EntityTags.class);
        entityTags.getTags().forEach(entityTag -> entityTag.setValue(entityTag.getValueForRead(objectMapper)));
        return entityTags;
    }
}

