/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.elasticsearch.ops;

import com.netflix.spinnaker.clouddriver.core.services.Front50Service;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.elasticsearch.descriptions.BulkUpsertEntityTagsDescription;
import com.netflix.spinnaker.clouddriver.elasticsearch.descriptions.UpsertEntityTagsDescription;
import com.netflix.spinnaker.clouddriver.elasticsearch.model.ElasticSearchEntityTagsProvider;
import com.netflix.spinnaker.clouddriver.elasticsearch.ops.BulkUpsertEntityTagsAtomicOperation;
import com.netflix.spinnaker.clouddriver.model.EntityTags;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsProvider;
import com.netflix.spinnaker.kork.core.RetrySupport;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class UpsertEntityTagsAtomicOperation
implements AtomicOperation<Void> {
    private static final String BASE_PHASE = "ENTITY_TAGS";
    private final RetrySupport retrySupport;
    private final Front50Service front50Service;
    private final AccountCredentialsProvider accountCredentialsProvider;
    private final ElasticSearchEntityTagsProvider entityTagsProvider;
    private final UpsertEntityTagsDescription entityTagsDescription;

    public UpsertEntityTagsAtomicOperation(RetrySupport retrySupport, Front50Service front50Service, AccountCredentialsProvider accountCredentialsProvider, ElasticSearchEntityTagsProvider entityTagsProvider, UpsertEntityTagsDescription tagEntityDescription) {
        this.retrySupport = retrySupport;
        this.front50Service = front50Service;
        this.accountCredentialsProvider = accountCredentialsProvider;
        this.entityTagsProvider = entityTagsProvider;
        this.entityTagsDescription = tagEntityDescription;
    }

    public Void operate(List priorOutputs) {
        BulkUpsertEntityTagsDescription bulkDescription = new BulkUpsertEntityTagsDescription();
        bulkDescription.isPartial = this.entityTagsDescription.isPartial;
        bulkDescription.entityTags = Collections.singletonList(this.entityTagsDescription);
        UpsertEntityTagsAtomicOperation.getTask().updateStatus(BASE_PHASE, String.format("Updating entity tags for %s (isPartial: %s, tags: %s)", Optional.ofNullable(this.entityTagsDescription.getId()).orElse(BulkUpsertEntityTagsAtomicOperation.entityRefId((AccountCredentialsProvider)this.accountCredentialsProvider, (EntityTags)this.entityTagsDescription).id), this.entityTagsDescription.isPartial, this.entityTagsDescription.getTags().stream().map(EntityTags.EntityTag::getName).collect(Collectors.joining(", "))));
        new BulkUpsertEntityTagsAtomicOperation(this.retrySupport, this.front50Service, this.accountCredentialsProvider, this.entityTagsProvider, bulkDescription).operate(priorOutputs);
        return null;
    }

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }
}

