/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.elasticsearch.validators;

import com.netflix.spinnaker.clouddriver.deploy.DescriptionValidator;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.clouddriver.elasticsearch.descriptions.BulkUpsertEntityTagsDescription;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="bulkUpsertEntityTagsDescriptionValidator")
public class BulkUpsertEntityTagsDescriptionValidator
extends DescriptionValidator<BulkUpsertEntityTagsDescription> {
    @Value(value="${entity-tags.max-concurrent-bulk-tags:1000}")
    Integer maxConcurrentBulkTags;

    public void validate(List priorDescriptions, BulkUpsertEntityTagsDescription description, ValidationErrors errors) {
        if (description.entityTags != null && description.entityTags.size() > this.maxConcurrentBulkTags) {
            errors.rejectValue("entityTags.length", "Max number of entity tags that can be submitted at once is " + this.maxConcurrentBulkTags);
        }
    }
}

