/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.netflix.spinnaker.clouddriver.elasticsearch.ElasticSearchEntityTagger;
import com.netflix.spinnaker.clouddriver.elasticsearch.converters.DeleteEntityTagsAtomicOperationConverter;
import com.netflix.spinnaker.clouddriver.elasticsearch.converters.UpsertEntityTagsAtomicOperationConverter;
import com.netflix.spinnaker.clouddriver.elasticsearch.model.ElasticSearchEntityTagsProvider;
import com.netflix.spinnaker.config.ElasticSearchConfigProperties;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"elastic-search.connection"})
@ComponentScan(value={"com.netflix.spinnaker.clouddriver.elasticsearch"})
@EnableConfigurationProperties(value={ElasticSearchConfigProperties.class})
public class ElasticSearchConfig {
    @Bean
    JestClient jestClient(ElasticSearchConfigProperties elasticSearchConfigProperties) {
        String elasticSearchConnection = elasticSearchConfigProperties.getConnection();
        JestClientFactory factory = new JestClientFactory();
        HttpClientConfig.Builder builder = (HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder(elasticSearchConnection).readTimeout(elasticSearchConfigProperties.getReadTimeout())).connTimeout(elasticSearchConfigProperties.getConnectionTimeout())).multiThreaded(true);
        factory.setHttpClientConfig(builder.build());
        return factory.getObject();
    }

    @Bean
    ElasticSearchEntityTagger elasticSearchEntityTagger(ElasticSearchEntityTagsProvider elasticSearchEntityTagsProvider, UpsertEntityTagsAtomicOperationConverter upsertEntityTagsAtomicOperationConverter, DeleteEntityTagsAtomicOperationConverter deleteEntityTagsAtomicOperationConverter) {
        return new ElasticSearchEntityTagger(elasticSearchEntityTagsProvider, upsertEntityTagsAtomicOperationConverter, deleteEntityTagsAtomicOperationConverter);
    }
}

