/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.cache;

import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.Keys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class CacheResultBuilder {
    private final long startTime;
    private final CacheMutation onDemand = new CacheMutation();
    private final Map<String, NamespaceCache> namespaceBuilders = new HashMap<String, NamespaceCache>();

    public CacheResultBuilder(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public CacheMutation getOnDemand() {
        return this.onDemand;
    }

    public NamespaceCache getNamespaceCache(String ns) {
        if (this.namespaceBuilders.containsKey(ns)) {
            return this.namespaceBuilders.get(ns);
        }
        NamespaceCache cache = new NamespaceCache(ns);
        this.namespaceBuilders.put(ns, cache);
        return cache;
    }

    public DefaultCacheResult build() {
        HashMap<String, List<String>> evict = new HashMap<String, List<String>>();
        HashMap<String, Collection<CacheData>> keep = new HashMap<String, Collection<CacheData>>();
        if (!this.onDemand.getToKeep().isEmpty()) {
            keep.put(Keys.Namespace.ON_DEMAND.ns, this.onDemand.getToKeep().values());
        }
        if (!this.onDemand.getToEvict().isEmpty()) {
            evict.put(Keys.Namespace.ON_DEMAND.ns, this.onDemand.getToEvict());
        }
        this.namespaceBuilders.forEach((namespace, item) -> {
            if (!item.getToKeep().isEmpty()) {
                keep.put((String)namespace, item.getCacheDatas());
            }
            if (!item.getToEvict().isEmpty()) {
                evict.put((String)namespace, item.getToEvict());
            }
        });
        return new DefaultCacheResult(keep, evict);
    }

    public static class CacheMutation {
        private final List<String> toEvict = new ArrayList<String>();
        private final Map<String, CacheData> toKeep = new HashMap<String, CacheData>();

        @Generated
        public List<String> getToEvict() {
            return this.toEvict;
        }

        @Generated
        public Map<String, CacheData> getToKeep() {
            return this.toKeep;
        }
    }

    public static class NamespaceCache {
        private final String namespace;
        private final List<String> toEvict = new ArrayList<String>();
        private final Map<String, CacheDataBuilder> toKeep = new HashMap<String, CacheDataBuilder>();

        public NamespaceCache(String namespace) {
            this.namespace = namespace;
        }

        public CacheDataBuilder getCacheDataBuilder(String key) {
            if (this.toKeep.containsKey(key)) {
                return this.toKeep.get(key);
            }
            CacheDataBuilder builder = new CacheDataBuilder(key);
            this.toKeep.put(key, builder);
            return builder;
        }

        public Collection<CacheData> getCacheDatas() {
            ArrayList<CacheData> result = new ArrayList<CacheData>(this.toKeep.size());
            this.toKeep.forEach((k, item) -> result.add((CacheData)item.build()));
            return result;
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public List<String> getToEvict() {
            return this.toEvict;
        }

        @Generated
        public Map<String, CacheDataBuilder> getToKeep() {
            return this.toKeep;
        }
    }

    public static class CacheDataBuilder {
        private final String id;
        private int ttlSeconds = -1;
        private Map<String, Object> attributes = new HashMap<String, Object>();
        private final Map<String, Collection<String>> relationships = new HashMap<String, Collection<String>>();

        public CacheDataBuilder(String id) {
            this.id = id;
        }

        public DefaultCacheData build() {
            return new DefaultCacheData(this.id, this.ttlSeconds, this.attributes, this.relationships);
        }

        public void setTtlSeconds(int value) {
            this.ttlSeconds = value;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
        }

        public Map<String, Collection<String>> getRelationships() {
            return this.relationships;
        }
    }
}

