/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.cache;

import com.google.common.base.CaseFormat;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.cache.KeyParser;
import com.netflix.spinnaker.clouddriver.huaweicloud.HuaweiCloudUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component(value="HuaweiCloudKeys")
public class Keys
implements KeyParser {
    private static final String SEPARATOR = ":";

    public Map<String, String> parseKey(String key) {
        return Keys.parse(key);
    }

    public String getCloudProvider() {
        return Keys.getCloudProviderId();
    }

    public Boolean canParseType(String type) {
        for (Namespace key : Namespace.values()) {
            if (!key.toString().equals(type)) continue;
            return true;
        }
        return false;
    }

    public Boolean canParseField(String field) {
        return false;
    }

    private static String getCloudProviderId() {
        return "huaweicloud";
    }

    private static Map emptyMap() {
        return Collections.emptyMap();
    }

    public static Map<String, String> parse(String key, Namespace targetType) {
        Map keys = Keys.parse(key);
        return !keys.isEmpty() && !targetType.ns.equals(keys.get("type")) ? Keys.emptyMap() : keys;
    }

    public static Map<String, String> parse(String key) {
        Map result;
        Namespace ns;
        if (HuaweiCloudUtils.isEmptyStr(key)) {
            return Keys.emptyMap();
        }
        String[] parts = key.split(SEPARATOR);
        if (parts.length < 2 || !Keys.getCloudProviderId().equals(parts[0])) {
            return Keys.emptyMap();
        }
        try {
            ns = Namespace.valueOf(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, parts[1]));
        }
        catch (Exception e) {
            return Keys.emptyMap();
        }
        switch (ns) {
            case IMAGES: {
                result = Keys.parseSimpleKey(parts);
                break;
            }
            case INSTANCE_TYPES: {
                result = Keys.parseSimpleKey(parts);
                break;
            }
            case NETWORKS: {
                result = Keys.parseSimpleKey(parts);
                break;
            }
            case SECURITY_GROUPS: {
                result = Keys.parseSecurityGroupKey(parts);
                break;
            }
            case SUBNETS: {
                result = Keys.parseSimpleKey(parts);
                break;
            }
            default: {
                return Keys.emptyMap();
            }
        }
        if (result.isEmpty()) {
            return result;
        }
        result.put("provider", parts[0]);
        result.put("type", parts[1]);
        return result;
    }

    public static String getImageKey(String imageId, String account, String region) {
        return Keys.getSimpleKey(Namespace.IMAGES, imageId, account, region);
    }

    public static String getInstanceTypeKey(String instanceType, String account, String region) {
        return Keys.getSimpleKey(Namespace.INSTANCE_TYPES, instanceType, account, region);
    }

    public static String getNetworkKey(String networkId, String account, String region) {
        return Keys.getSimpleKey(Namespace.NETWORKS, networkId, account, region);
    }

    public static String getSecurityGroupKey(String securityGroupName, String securityGroupId, String account, String region) {
        String identifier = securityGroupName + SEPARATOR + securityGroupId;
        return Keys.getSimpleKey(Namespace.SECURITY_GROUPS, identifier, account, region);
    }

    private static Map parseSecurityGroupKey(String[] parts) {
        if (parts.length != 6) {
            return Keys.emptyMap();
        }
        Names names = Names.parseName((String)parts[4]);
        if (HuaweiCloudUtils.isEmptyStr(names.getApp())) {
            return Keys.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("application", names.getApp());
        result.put("account", parts[2]);
        result.put("region", parts[3]);
        result.put("name", parts[4]);
        result.put("id", parts[5]);
        return result;
    }

    public static String getSubnetKey(String subnetId, String account, String region) {
        return Keys.getSimpleKey(Namespace.SUBNETS, subnetId, account, region);
    }

    private static String getSimpleKey(Namespace namespace, String identifier, String account, String region) {
        return Keys.getCloudProviderId() + SEPARATOR + String.valueOf((Object)namespace) + SEPARATOR + account + SEPARATOR + region + SEPARATOR + identifier;
    }

    private static Map parseSimpleKey(String[] parts) {
        if (parts.length != 5) {
            return Keys.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("account", parts[2]);
        result.put("region", parts[3]);
        result.put("id", parts[4]);
        return result;
    }

    public static enum Namespace {
        IMAGES,
        INSTANCE_TYPES,
        NETWORKS,
        SECURITY_GROUPS,
        SUBNETS,
        ON_DEMAND;

        public final String ns = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());

        public String toString() {
            return this.ns;
        }
    }
}

