/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.client;

import com.huawei.openstack4j.api.OSClient;
import com.huawei.openstack4j.model.compute.ext.AvailabilityZone;
import com.huawei.openstack4j.openstack.ecs.v1.domain.Flavor;
import com.huawei.openstack4j.openstack.ims.v2.domain.Image;
import com.huawei.openstack4j.openstack.vpc.v1.domain.SecurityGroup;
import com.huawei.openstack4j.openstack.vpc.v1.domain.Subnet;
import com.huawei.openstack4j.openstack.vpc.v1.domain.Vpc;
import com.netflix.spinnaker.clouddriver.huaweicloud.client.AuthorizedClientProvider;
import com.netflix.spinnaker.clouddriver.huaweicloud.client.HuaweiCloudClient;
import com.netflix.spinnaker.clouddriver.huaweicloud.exception.HuaweiCloudException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class HuaweiCloudClientImpl
implements HuaweiCloudClient {
    private final AuthorizedClientProvider provider;

    public HuaweiCloudClientImpl(AuthorizedClientProvider provider) {
        this.provider = provider;
    }

    private static <T> T handleInvoking(String doWhat, Callable<T> closure, T defaultResult) {
        try {
            T r = closure.call();
            return r == null ? defaultResult : r;
        }
        catch (Exception e) {
            throw new HuaweiCloudException(doWhat, e);
        }
    }

    private static List emptyList() {
        return Collections.emptyList();
    }

    private OSClient getRegionClient(String region) {
        return this.provider.getAuthClient().useRegion(region);
    }

    @Override
    public List<? extends AvailabilityZone> getZones(String region) throws HuaweiCloudException {
        return HuaweiCloudClientImpl.handleInvoking(String.format("getting zones in region(%s)", region), () -> this.getRegionClient(region).compute().zones().list(), HuaweiCloudClientImpl.emptyList());
    }

    @Override
    public List<? extends Image> getImages(String region) throws HuaweiCloudException {
        return HuaweiCloudClientImpl.handleInvoking(String.format("getting images in region(%s)", region), () -> this.getRegionClient(region).imsV2().images().list((Map)new HashMap(){
            {
                this.put("__imagetype", "gold");
                this.put("status", "active");
                this.put("virtual_env_type", "FusionCompute");
            }
        }), HuaweiCloudClientImpl.emptyList());
    }

    @Override
    public List<? extends Flavor> getInstanceTypes(String region, String az) throws HuaweiCloudException {
        return HuaweiCloudClientImpl.handleInvoking(String.format("getting flavors in availability zone(%s) of region(%s)", az, region), () -> this.getRegionClient(region).ecs().servers().getSpecifications(az), HuaweiCloudClientImpl.emptyList());
    }

    @Override
    public List<? extends SecurityGroup> getSecurityGroups(String region) throws HuaweiCloudException {
        return HuaweiCloudClientImpl.handleInvoking(String.format("getting all security groups in region(%s)", region), () -> this.getRegionClient(region).vpc().securityGroups().list(), HuaweiCloudClientImpl.emptyList());
    }

    @Override
    public List<? extends Subnet> getSubnets(String region) throws HuaweiCloudException {
        return HuaweiCloudClientImpl.handleInvoking(String.format("getting all subnets in region(%s)", region), () -> this.getRegionClient(region).vpc().subnets().list(), HuaweiCloudClientImpl.emptyList());
    }

    @Override
    public List<? extends Vpc> getVpcs(String region) throws HuaweiCloudException {
        return HuaweiCloudClientImpl.handleInvoking(String.format("getting all vpcs in region(%s)", region), () -> this.getRegionClient(region).vpc().vpcs().list(), HuaweiCloudClientImpl.emptyList());
    }
}

