/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.controller;

import com.netflix.spinnaker.cats.mem.InMemoryCache;
import com.netflix.spinnaker.clouddriver.huaweicloud.HuaweiCloudUtils;
import com.netflix.spinnaker.clouddriver.huaweicloud.controller.ImageProvider;
import com.netflix.spinnaker.clouddriver.huaweicloud.model.HuaweiCloudImage;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/huaweicloud/images"})
public class HuaweiCloudImageController {
    private final ImageProvider imageProvider;

    @Autowired
    public HuaweiCloudImageController(ImageProvider imageProvider) {
        this.imageProvider = imageProvider;
    }

    @RequestMapping(value={"/find"}, method={RequestMethod.GET})
    public Set<HuaweiCloudImage> find(@RequestParam(required=false) String account, @RequestParam(required=false) String q, @RequestParam(required=false) String region) {
        Set<HuaweiCloudImage> result = this.imageProvider.getAll(account, region);
        if (result.isEmpty()) {
            return Collections.emptySet();
        }
        return result.stream().filter(this.getQueryFilter(q)).sorted(Comparator.comparing(image -> image.getName())).collect(Collectors.toSet());
    }

    private Predicate<HuaweiCloudImage> getQueryFilter(String q) {
        Predicate<HuaweiCloudImage> queryFilter = i -> true;
        if (!HuaweiCloudUtils.isEmptyStr(q) && q.trim().length() > 0) {
            Object glob = q.trim();
            if (!(((String)glob).contains("*") || ((String)glob).contains("?") || ((String)glob).contains("[") || ((String)glob).contains("\\"))) {
                glob = "*" + (String)glob + "*";
            }
            Pattern pattern = new InMemoryCache.Glob((String)glob).toPattern();
            queryFilter = i -> pattern.matcher(i.getName()).matches();
        }
        return queryFilter;
    }
}

