/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.provider;

import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.agent.AgentSchedulerAware;
import com.netflix.spinnaker.clouddriver.cache.SearchableProvider;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.Keys;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@ConditionalOnProperty(value={"huaweicloud.enabled"})
public class HuaweiCloudInfrastructureProvider
extends AgentSchedulerAware
implements SearchableProvider {
    private final Collection<Agent> agents;
    private final Set<String> defaultCaches = new HashSet<String>(){
        {
            this.add(Keys.Namespace.IMAGES.ns);
            this.add(Keys.Namespace.INSTANCE_TYPES.ns);
            this.add(Keys.Namespace.NETWORKS.ns);
            this.add(Keys.Namespace.SECURITY_GROUPS.ns);
            this.add(Keys.Namespace.SUBNETS.ns);
        }
    };
    private final Map<String, String> urlMappingTemplates = Collections.emptyMap();
    private final Map<SearchableProvider.SearchableResource, SearchableProvider.SearchResultHydrator> searchResultHydrators = Collections.emptyMap();

    public HuaweiCloudInfrastructureProvider(Collection<Agent> agents) {
        this.agents = agents;
    }

    public String getProviderName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Collection<Agent> getAgents() {
        return this.agents;
    }

    public Set<String> getDefaultCaches() {
        return this.defaultCaches;
    }

    public Map<String, String> getUrlMappingTemplates() {
        return this.urlMappingTemplates;
    }

    public Map<SearchableProvider.SearchableResource, SearchableProvider.SearchResultHydrator> getSearchResultHydrators() {
        return this.searchResultHydrators;
    }

    public Map<String, String> parseKey(String key) {
        return Keys.parse(key);
    }
}

