/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.provider.Provider;
import com.netflix.spinnaker.clouddriver.huaweicloud.provider.HuaweiCloudInfrastructureProvider;
import com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent.HuaweiCloudImageCachingAgent;
import com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent.HuaweiCloudInstanceTypeCachingAgent;
import com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent.HuaweiCloudNetworkCachingAgent;
import com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent.HuaweiCloudSecurityGroupCachingAgent;
import com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent.HuaweiCloudSubnetCachingAgent;
import com.netflix.spinnaker.clouddriver.huaweicloud.security.HuaweiCloudNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.security.AccountCredentialsRepository;
import com.netflix.spinnaker.clouddriver.security.ProviderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Scope;

@Configuration
public class HuaweiCloudInfrastructureProviderConfig {
    @Bean
    @DependsOn(value={"synchronizeHuaweiCloudNamedAccountCredentials"})
    public HuaweiCloudInfrastructureProvider huaweiCloudInfastructureProvider(AccountCredentialsRepository accountCredentialsRepository, ObjectMapper objectMapper, Registry registry) {
        HuaweiCloudInfrastructureProvider provider = new HuaweiCloudInfrastructureProvider(Collections.newSetFromMap(new ConcurrentHashMap()));
        this.synchronizeHuaweiCloudInfrastructureProvider(provider, accountCredentialsRepository, objectMapper, registry);
        return provider;
    }

    @Scope(value="prototype")
    @Bean
    public HuaweiCloudInfrastructureProviderSynchronizer synchronizeHuaweiCloudInfrastructureProvider(HuaweiCloudInfrastructureProvider infastructureProvider, AccountCredentialsRepository accountCredentialsRepository, ObjectMapper objectMapper, Registry registry) {
        Set scheduledAccounts = ProviderUtils.getScheduledAccounts((Provider)infastructureProvider);
        Set allAccounts = ProviderUtils.buildThreadSafeSetOfAccounts((AccountCredentialsRepository)accountCredentialsRepository, HuaweiCloudNamedAccountCredentials.class);
        ArrayList newlyAddedAgents = new ArrayList();
        allAccounts.forEach(credentials -> {
            if (!scheduledAccounts.contains(credentials.getName())) {
                credentials.getRegions().forEach(region -> {
                    newlyAddedAgents.add(new HuaweiCloudImageCachingAgent((HuaweiCloudNamedAccountCredentials)((Object)credentials), objectMapper, (String)region));
                    newlyAddedAgents.add(new HuaweiCloudInstanceTypeCachingAgent((HuaweiCloudNamedAccountCredentials)((Object)credentials), objectMapper, (String)region));
                    newlyAddedAgents.add(new HuaweiCloudNetworkCachingAgent((HuaweiCloudNamedAccountCredentials)((Object)credentials), objectMapper, (String)region));
                    newlyAddedAgents.add(new HuaweiCloudSubnetCachingAgent((HuaweiCloudNamedAccountCredentials)((Object)credentials), objectMapper, (String)region));
                    newlyAddedAgents.add(new HuaweiCloudSecurityGroupCachingAgent((HuaweiCloudNamedAccountCredentials)((Object)credentials), objectMapper, registry, (String)region));
                });
            }
        });
        if (infastructureProvider.getAgentScheduler() != null) {
            ProviderUtils.rescheduleAgents((Provider)infastructureProvider, newlyAddedAgents);
        }
        if (!newlyAddedAgents.isEmpty()) {
            infastructureProvider.getAgents().addAll(newlyAddedAgents);
        }
        return new HuaweiCloudInfrastructureProviderSynchronizer();
    }

    class HuaweiCloudInfrastructureProviderSynchronizer {
        HuaweiCloudInfrastructureProviderSynchronizer() {
        }
    }
}

