/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.agent.AccountAware;
import com.netflix.spinnaker.cats.agent.CachingAgent;
import com.netflix.spinnaker.clouddriver.huaweicloud.client.HuaweiCloudClient;
import com.netflix.spinnaker.clouddriver.huaweicloud.provider.HuaweiCloudInfrastructureProvider;
import com.netflix.spinnaker.clouddriver.huaweicloud.security.HuaweiCloudNamedAccountCredentials;

public abstract class AbstractHuaweiCloudCachingAgent
implements CachingAgent,
AccountAware {
    final HuaweiCloudNamedAccountCredentials credentials;
    final ObjectMapper objectMapper;
    final String region;

    public AbstractHuaweiCloudCachingAgent(HuaweiCloudNamedAccountCredentials credentials, ObjectMapper objectMapper, String region) {
        this.credentials = credentials;
        this.objectMapper = objectMapper;
        this.region = region;
    }

    public String getAccountName() {
        return this.credentials.getName();
    }

    public String getProviderName() {
        return HuaweiCloudInfrastructureProvider.class.getName();
    }

    public String getAgentType() {
        return String.format("%s/%s/%s", this.getAccountName(), this.region, this.getAgentName());
    }

    HuaweiCloudClient getCloudClient() {
        return this.credentials.getCloudClient();
    }

    abstract String getAgentName();
}

