/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.cache.OnDemandAgent;
import com.netflix.spinnaker.clouddriver.huaweicloud.HuaweiCloudUtils;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.CacheResultBuilder;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.Keys;
import com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent.AbstractHuaweiCloudCachingAgent;
import com.netflix.spinnaker.clouddriver.huaweicloud.security.HuaweiCloudNamedAccountCredentials;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public abstract class AbstractOnDemandCachingAgent
extends AbstractHuaweiCloudCachingAgent
implements OnDemandAgent {
    private static final Logger log = HuaweiCloudUtils.getLogger(AbstractOnDemandCachingAgent.class);
    private final String namespace;

    public AbstractOnDemandCachingAgent(HuaweiCloudNamedAccountCredentials credentials, ObjectMapper objectMapper, String namespace, String region) {
        super(credentials, objectMapper, region);
        this.namespace = namespace;
    }

    public String getOnDemandAgentType() {
        return this.getAgentType() + "-OnDemand";
    }

    public Collection<Map<String, Object>> pendingOnDemandRequests(ProviderCache providerCache) {
        Collection datas = providerCache.getAll(Keys.Namespace.ON_DEMAND.ns);
        if (HuaweiCloudUtils.isEmptyCollection(datas)) {
            return Collections.emptyList();
        }
        return datas.stream().filter(cacheData -> {
            Map<String, String> parsedKey = Keys.parse(cacheData.getId());
            return !parsedKey.isEmpty() && this.getAccountName().equals(parsedKey.get("account")) && this.region.equals(parsedKey.get("region"));
        }).map(cacheData -> {
            final Map<String, String> details = Keys.parse(cacheData.getId());
            final Map attributes = cacheData.getAttributes();
            return new HashMap<String, Object>(){
                {
                    this.put("details", details);
                    this.put("moniker", AbstractOnDemandCachingAgent.this.convertOnDemandDetails(details));
                    this.put("cacheTime", attributes.get("cacheTime"));
                    this.put("processedTime", attributes.get("processedTime"));
                    this.put("processedCount", attributes.get("processedCount"));
                }
            };
        }).collect(Collectors.toList());
    }

    public CacheResult loadData(ProviderCache providerCache) {
        long startTime = System.currentTimeMillis();
        CacheResultBuilder cacheResultBuilder = new CacheResultBuilder(startTime);
        this.buildCurrentNamespaceCacheData(cacheResultBuilder);
        Set<String> keys = cacheResultBuilder.getNamespaceCache(this.namespace).getToKeep().keySet();
        Collection datas = providerCache.getAll(Keys.Namespace.ON_DEMAND.ns, keys);
        if (!HuaweiCloudUtils.isEmptyCollection(datas)) {
            datas.forEach(cacheData -> {
                long cacheTime = 0L;
                if (cacheData.getAttributes().get("cacheTime") != null) {
                    cacheTime = (Long)cacheData.getAttributes().get("cacheTime");
                }
                if (cacheTime < startTime) {
                    int processedCount = 0;
                    if (cacheData.getAttributes().get("processedCount") != null) {
                        processedCount = (Integer)cacheData.getAttributes().get("processedCount");
                    }
                    if (processedCount > 0) {
                        cacheResultBuilder.getOnDemand().getToEvict().add(cacheData.getId());
                    } else {
                        cacheResultBuilder.getOnDemand().getToKeep().put(cacheData.getId(), (CacheData)cacheData);
                    }
                } else {
                    log.warn("The cache time({}) of OnDemand data(key={}) is bigger than now({})", new Object[]{cacheTime, cacheData.getId(), startTime});
                }
            });
        }
        DefaultCacheResult result = cacheResultBuilder.build();
        ((Collection)result.getCacheResults().getOrDefault(Keys.Namespace.ON_DEMAND.ns, Collections.emptyList())).forEach(cacheData -> {
            cacheData.getAttributes().put("processedTime", System.currentTimeMillis());
            int count = 0;
            if (cacheData.getAttributes().get("processedCount") != null) {
                count = (Integer)cacheData.getAttributes().get("processedCount");
            }
            cacheData.getAttributes().put("processedCount", count + 1);
        });
        return result;
    }

    protected OnDemandAgent.OnDemandResult handle(ProviderCache providerCache, String name) {
        Optional resource = (Optional)this.getMetricsSupport().readData(() -> this.getResourceByName(name));
        if (resource.isPresent()) {
            CacheResultBuilder cacheResultBuilder = new CacheResultBuilder(Long.MAX_VALUE);
            this.buildSingleResourceCacheData(cacheResultBuilder, resource.get());
            CacheResult cacheResult = (CacheResult)this.getMetricsSupport().transformData(() -> cacheResultBuilder.build());
            CacheData cacheData = (CacheData)this.getMetricsSupport().onDemandStore(() -> {
                String cacheResults = "";
                try {
                    cacheResults = this.objectMapper.writeValueAsString((Object)cacheResult.getCacheResults());
                }
                catch (Exception e) {
                    log.error("Error serializing cache results to string, error={}", (Throwable)e);
                }
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("cacheTime", System.currentTimeMillis());
                attributes.put("cacheResults", cacheResults);
                attributes.put("processedCount", 0);
                return new DefaultCacheData(this.getResourceCacheDataId(resource.get()), (int)Duration.ofMinutes(10L).getSeconds(), Collections.unmodifiableMap(attributes), Collections.emptyMap());
            });
            providerCache.putCacheData(Keys.Namespace.ON_DEMAND.ns, cacheData);
            return new OnDemandAgent.OnDemandResult(this.getOnDemandAgentType(), cacheResult, Collections.emptyMap());
        }
        final Collection<String> identifiers = this.getOnDemandKeysToEvict(providerCache, name);
        providerCache.evictDeletedItems(Keys.Namespace.ON_DEMAND.ns, identifiers);
        return new OnDemandAgent.OnDemandResult(this.getOnDemandAgentType(), (CacheResult)new DefaultCacheResult(Collections.emptyMap()), (Map)new HashMap(){
            {
                this.put(AbstractOnDemandCachingAgent.this.namespace, identifiers);
            }
        });
    }

    abstract void buildCurrentNamespaceCacheData(CacheResultBuilder var1);

    abstract void buildSingleResourceCacheData(CacheResultBuilder var1, Object var2);

    abstract Optional<Object> getResourceByName(String var1);

    abstract String getResourceCacheDataId(Object var1);

    abstract Collection<String> getOnDemandKeysToEvict(ProviderCache var1, String var2);
}

