/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.openstack4j.openstack.ims.v2.domain.Image;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.CacheResultBuilder;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.Keys;
import com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent.AbstractHuaweiCloudCachingAgent;
import com.netflix.spinnaker.clouddriver.huaweicloud.security.HuaweiCloudNamedAccountCredentials;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class HuaweiCloudImageCachingAgent
extends AbstractHuaweiCloudCachingAgent {
    public HuaweiCloudImageCachingAgent(HuaweiCloudNamedAccountCredentials credentials, ObjectMapper objectMapper, String region) {
        super(credentials, objectMapper, region);
    }

    @Override
    String getAgentName() {
        return this.getClass().getSimpleName();
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return Collections.unmodifiableCollection(new ArrayList<AgentDataType>(){
            {
                this.add(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.IMAGES.ns));
            }
        });
    }

    public CacheResult loadData(ProviderCache providerCache) {
        List<? extends Image> images = this.getCloudClient().getImages(this.region);
        return this.buildCacheResult(images);
    }

    private CacheResult buildCacheResult(List<? extends Image> images) {
        CacheResultBuilder cacheResultBuilder = new CacheResultBuilder(0L);
        CacheResultBuilder.NamespaceCache nsCache = cacheResultBuilder.getNamespaceCache(Keys.Namespace.IMAGES.ns);
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        images.forEach(arg_0 -> this.lambda$buildCacheResult$0(nsCache, (TypeReference)typeRef, arg_0));
        return cacheResultBuilder.build();
    }

    private /* synthetic */ void lambda$buildCacheResult$0(CacheResultBuilder.NamespaceCache nsCache, TypeReference typeRef, Image image) {
        nsCache.getCacheDataBuilder(Keys.getImageKey(image.getId(), this.getAccountName(), this.region)).setAttributes((Map)this.objectMapper.convertValue((Object)image, typeRef));
    }
}

