/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.openstack4j.openstack.ecs.v1.domain.Flavor;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.huaweicloud.HuaweiCloudUtils;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.CacheResultBuilder;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.Keys;
import com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent.AbstractHuaweiCloudCachingAgent;
import com.netflix.spinnaker.clouddriver.huaweicloud.security.HuaweiCloudNamedAccountCredentials;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class HuaweiCloudInstanceTypeCachingAgent
extends AbstractHuaweiCloudCachingAgent {
    private static final Logger log = HuaweiCloudUtils.getLogger(HuaweiCloudInstanceTypeCachingAgent.class);

    public HuaweiCloudInstanceTypeCachingAgent(HuaweiCloudNamedAccountCredentials credentials, ObjectMapper objectMapper, String region) {
        super(credentials, objectMapper, region);
    }

    @Override
    String getAgentName() {
        return this.getClass().getSimpleName();
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return Collections.unmodifiableCollection(new ArrayList<AgentDataType>(){
            {
                this.add(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.INSTANCE_TYPES.ns));
            }
        });
    }

    public CacheResult loadData(ProviderCache providerCache) {
        List<String> zones = this.credentials.getRegionToZones().getOrDefault(this.region, Collections.emptyList());
        if (zones.isEmpty()) {
            log.warn("no availability zones for region({})", (Object)this.region);
            return null;
        }
        CacheResultBuilder cacheResultBuilder = new CacheResultBuilder(0L);
        zones.forEach(zone -> {
            List<? extends Flavor> flavors = this.getCloudClient().getInstanceTypes(this.region, (String)zone);
            if (!flavors.isEmpty()) {
                this.buildCacheData(cacheResultBuilder, flavors);
            }
        });
        return cacheResultBuilder.build();
    }

    private void buildCacheData(CacheResultBuilder cacheResultBuilder, List<? extends Flavor> flavors) {
        CacheResultBuilder.NamespaceCache nsCache = cacheResultBuilder.getNamespaceCache(Keys.Namespace.INSTANCE_TYPES.ns);
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        flavors.forEach(arg_0 -> this.lambda$buildCacheData$1(nsCache, (TypeReference)typeRef, arg_0));
    }

    private /* synthetic */ void lambda$buildCacheData$1(CacheResultBuilder.NamespaceCache nsCache, TypeReference typeRef, Flavor flavor) {
        nsCache.getCacheDataBuilder(Keys.getInstanceTypeKey(flavor.getId(), this.getAccountName(), this.region)).setAttributes((Map)this.objectMapper.convertValue((Object)flavor, typeRef));
    }
}

