/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.openstack4j.openstack.vpc.v1.domain.Vpc;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.CacheResultBuilder;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.Keys;
import com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent.AbstractHuaweiCloudCachingAgent;
import com.netflix.spinnaker.clouddriver.huaweicloud.security.HuaweiCloudNamedAccountCredentials;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class HuaweiCloudNetworkCachingAgent
extends AbstractHuaweiCloudCachingAgent {
    public HuaweiCloudNetworkCachingAgent(HuaweiCloudNamedAccountCredentials credentials, ObjectMapper objectMapper, String region) {
        super(credentials, objectMapper, region);
    }

    @Override
    String getAgentName() {
        return this.getClass().getSimpleName();
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return Collections.unmodifiableCollection(new ArrayList<AgentDataType>(){
            {
                this.add(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.NETWORKS.ns));
            }
        });
    }

    public CacheResult loadData(ProviderCache providerCache) {
        List<? extends Vpc> vpcs = this.getCloudClient().getVpcs(this.region);
        return this.buildCacheResult(vpcs);
    }

    private CacheResult buildCacheResult(List<? extends Vpc> vpcs) {
        CacheResultBuilder cacheResultBuilder = new CacheResultBuilder(0L);
        CacheResultBuilder.NamespaceCache nsCache = cacheResultBuilder.getNamespaceCache(Keys.Namespace.NETWORKS.ns);
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        vpcs.forEach(arg_0 -> this.lambda$buildCacheResult$0(nsCache, (TypeReference)typeRef, arg_0));
        return cacheResultBuilder.build();
    }

    private /* synthetic */ void lambda$buildCacheResult$0(CacheResultBuilder.NamespaceCache nsCache, TypeReference typeRef, Vpc vpc) {
        nsCache.getCacheDataBuilder(Keys.getNetworkKey(vpc.getId(), this.getAccountName(), this.region)).setAttributes((Map)this.objectMapper.convertValue((Object)vpc, typeRef));
    }
}

