/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.openstack4j.openstack.vpc.v1.domain.SecurityGroup;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.cache.OnDemandAgent;
import com.netflix.spinnaker.clouddriver.cache.OnDemandMetricsSupport;
import com.netflix.spinnaker.clouddriver.cache.OnDemandType;
import com.netflix.spinnaker.clouddriver.huaweicloud.HuaweiCloudUtils;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.CacheResultBuilder;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.Keys;
import com.netflix.spinnaker.clouddriver.huaweicloud.model.HuaweiCloudSecurityGroupCacheData;
import com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent.AbstractOnDemandCachingAgent;
import com.netflix.spinnaker.clouddriver.huaweicloud.security.HuaweiCloudNamedAccountCredentials;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class HuaweiCloudSecurityGroupCachingAgent
extends AbstractOnDemandCachingAgent {
    private static final Logger log = HuaweiCloudUtils.getLogger(HuaweiCloudSecurityGroupCachingAgent.class);
    private final OnDemandMetricsSupport onDemandMetricsSupport;

    public HuaweiCloudSecurityGroupCachingAgent(HuaweiCloudNamedAccountCredentials credentials, ObjectMapper objectMapper, Registry registry, String region) {
        super(credentials, objectMapper, Keys.Namespace.SECURITY_GROUPS.ns, region);
        this.onDemandMetricsSupport = new OnDemandMetricsSupport(registry, (OnDemandAgent)this, "huaweicloud:" + String.valueOf(OnDemandType.SecurityGroup));
    }

    @Override
    String getAgentName() {
        return this.getClass().getSimpleName();
    }

    public OnDemandMetricsSupport getMetricsSupport() {
        return this.onDemandMetricsSupport;
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return Collections.unmodifiableCollection(new ArrayList<AgentDataType>(){
            {
                this.add(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.SECURITY_GROUPS.ns));
            }
        });
    }

    public boolean handles(OnDemandType type, String cloudProvider) {
        return OnDemandType.SecurityGroup.equals((Object)type) && "huaweicloud".equals(cloudProvider);
    }

    public OnDemandAgent.OnDemandResult handle(ProviderCache providerCache, Map<String, ? extends Object> data) {
        if (HuaweiCloudUtils.isEmptyStr(data.get("securityGroupName")) || !this.getAccountName().equals(data.get("account")) || !this.region.equals(data.get("region"))) {
            return null;
        }
        return this.handle(providerCache, (String)data.get("securityGroupName"));
    }

    @Override
    Optional<Object> getResourceByName(String name) {
        if (HuaweiCloudUtils.isEmptyStr(name)) {
            return Optional.empty();
        }
        List<? extends SecurityGroup> groups = this.getCloudClient().getSecurityGroups(this.region);
        if (groups.isEmpty()) {
            return Optional.empty();
        }
        List groups1 = groups.stream().filter(it -> name.equals(it.getName())).collect(Collectors.toList());
        if (groups1.size() == 1) {
            return Optional.of(groups1.get(0));
        }
        log.warn("There is {} with name={} in region={}", new Object[]{groups1.isEmpty() ? "no security group" : "more than one security groups", name, this.region});
        return Optional.empty();
    }

    @Override
    String getResourceCacheDataId(Object resource) {
        SecurityGroup seg = (SecurityGroup)resource;
        return Keys.getSecurityGroupKey(seg.getName(), seg.getId(), this.getAccountName(), this.region);
    }

    @Override
    Collection<String> getOnDemandKeysToEvict(ProviderCache providerCache, String name) {
        return providerCache.filterIdentifiers(Keys.Namespace.SECURITY_GROUPS.ns, Keys.getSecurityGroupKey(name, "*", this.getAccountName(), this.region));
    }

    @Override
    void buildCurrentNamespaceCacheData(CacheResultBuilder cacheResultBuilder) {
        List<? extends SecurityGroup> securityGroups = this.getCloudClient().getSecurityGroups(this.region);
        this.buildNamespaceCacheData(cacheResultBuilder, securityGroups, securityGroups);
    }

    @Override
    void buildSingleResourceCacheData(CacheResultBuilder cacheResultBuilder, Object resource) {
        ArrayList<SecurityGroup> securityGroups = new ArrayList<SecurityGroup>(1);
        securityGroups.add((SecurityGroup)resource);
        List<? extends SecurityGroup> allSecurityGroups = this.getCloudClient().getSecurityGroups(this.region);
        this.buildNamespaceCacheData(cacheResultBuilder, securityGroups, allSecurityGroups);
    }

    private void buildNamespaceCacheData(CacheResultBuilder cacheResultBuilder, List<? extends SecurityGroup> securityGroups, List<? extends SecurityGroup> allSecurityGroups) {
        CacheResultBuilder.NamespaceCache nsCache = cacheResultBuilder.getNamespaceCache(Keys.Namespace.SECURITY_GROUPS.ns);
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        Map<String, String> groupId2CacheIds = allSecurityGroups.stream().collect(Collectors.toMap(it -> it.getId(), it -> Keys.getSecurityGroupKey(it.getName(), it.getId(), this.getAccountName(), this.region)));
        securityGroups.forEach(arg_0 -> this.lambda$buildNamespaceCacheData$4(groupId2CacheIds, nsCache, (TypeReference)typeRef, arg_0));
    }

    private /* synthetic */ void lambda$buildNamespaceCacheData$4(Map groupId2CacheIds, CacheResultBuilder.NamespaceCache nsCache, TypeReference typeRef, SecurityGroup item) {
        if (!groupId2CacheIds.containsKey(item.getId())) {
            log.warn(String.format("Can't find the security group(id={}) in current security groups", item.getId()));
            return;
        }
        HashMap<String, String> relevantSecurityGroups = new HashMap<String, String>();
        List rules = item.getSecurityGroupRules();
        if (!HuaweiCloudUtils.isEmptyCollection(rules)) {
            rules.forEach(rule -> {
                String remoteGroupId = rule.getRemoteGroupId();
                if (!HuaweiCloudUtils.isEmptyStr(remoteGroupId)) {
                    if (groupId2CacheIds.containsKey(remoteGroupId)) {
                        relevantSecurityGroups.put(remoteGroupId, (String)groupId2CacheIds.get(remoteGroupId));
                    } else {
                        log.warn(String.format("Can't find the remote security group(id={}) for rule({}) of security group(id={})", remoteGroupId, rule.getId(), item.getId()));
                    }
                }
            });
        }
        nsCache.getCacheDataBuilder((String)groupId2CacheIds.get(item.getId())).setAttributes((Map)this.objectMapper.convertValue((Object)new HuaweiCloudSecurityGroupCacheData(item, relevantSecurityGroups), typeRef));
    }
}

