/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.openstack4j.openstack.vpc.v1.domain.Subnet;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.CacheResultBuilder;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.Keys;
import com.netflix.spinnaker.clouddriver.huaweicloud.provider.agent.AbstractHuaweiCloudCachingAgent;
import com.netflix.spinnaker.clouddriver.huaweicloud.security.HuaweiCloudNamedAccountCredentials;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class HuaweiCloudSubnetCachingAgent
extends AbstractHuaweiCloudCachingAgent {
    public HuaweiCloudSubnetCachingAgent(HuaweiCloudNamedAccountCredentials credentials, ObjectMapper objectMapper, String region) {
        super(credentials, objectMapper, region);
    }

    @Override
    String getAgentName() {
        return this.getClass().getSimpleName();
    }

    public Collection<AgentDataType> getProvidedDataTypes() {
        return Collections.unmodifiableCollection(new ArrayList<AgentDataType>(){
            {
                this.add(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.SUBNETS.ns));
            }
        });
    }

    public CacheResult loadData(ProviderCache providerCache) {
        List<? extends Subnet> subnets = this.getCloudClient().getSubnets(this.region);
        return this.buildCacheResult(subnets);
    }

    private CacheResult buildCacheResult(List<? extends Subnet> subnets) {
        CacheResultBuilder cacheResultBuilder = new CacheResultBuilder(0L);
        CacheResultBuilder.NamespaceCache nsCache = cacheResultBuilder.getNamespaceCache(Keys.Namespace.SUBNETS.ns);
        TypeReference<Map<String, Object>> typeRef = new TypeReference<Map<String, Object>>(){};
        subnets.forEach(arg_0 -> this.lambda$buildCacheResult$0(nsCache, (TypeReference)typeRef, arg_0));
        return cacheResultBuilder.build();
    }

    private /* synthetic */ void lambda$buildCacheResult$0(CacheResultBuilder.NamespaceCache nsCache, TypeReference typeRef, Subnet subnet) {
        if (!StringUtils.isEmpty((Object)subnet.getVpcId())) {
            nsCache.getCacheDataBuilder(Keys.getSubnetKey(subnet.getId(), this.getAccountName(), this.region)).setAttributes((Map)this.objectMapper.convertValue((Object)subnet, typeRef));
        }
    }
}

