/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.openstack4j.openstack.ims.v2.domain.Image;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.huaweicloud.HuaweiCloudUtils;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.Keys;
import com.netflix.spinnaker.clouddriver.huaweicloud.controller.ImageProvider;
import com.netflix.spinnaker.clouddriver.huaweicloud.model.HuaweiCloudImage;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class HuaweiCloudImageProvider
implements ImageProvider {
    private final Cache cacheView;
    private final ObjectMapper objectMapper;

    @Autowired
    public HuaweiCloudImageProvider(Cache cacheView, ObjectMapper objectMapper) {
        this.cacheView = cacheView;
        this.objectMapper = objectMapper;
    }

    @Override
    public Set<HuaweiCloudImage> getAll(String account, String region) {
        Collection data = this.cacheView.getAll(Keys.Namespace.IMAGES.ns, this.cacheView.filterIdentifiers(Keys.Namespace.IMAGES.ns, Keys.getImageKey("*", StringUtils.isEmpty((Object)account) ? "*" : account, StringUtils.isEmpty((Object)region) ? "*" : region)));
        if (HuaweiCloudUtils.isEmptyCollection(data)) {
            return Collections.emptySet();
        }
        return data.stream().map(cacheData -> this.fromCacheData((CacheData)cacheData)).filter(it -> it != null).collect(Collectors.toSet());
    }

    HuaweiCloudImage fromCacheData(CacheData cacheData) {
        Map<String, String> parts = Keys.parse(cacheData.getId(), Keys.Namespace.IMAGES);
        if (parts.isEmpty()) {
            return null;
        }
        Image image = (Image)this.objectMapper.convertValue((Object)cacheData.getAttributes(), Image.class);
        return new HuaweiCloudImage(image.getId(), image.getName(), parts.get("region"), parts.get("account"));
    }
}

