/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.openstack4j.openstack.ecs.v1.domain.Flavor;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.huaweicloud.HuaweiCloudUtils;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.Keys;
import com.netflix.spinnaker.clouddriver.huaweicloud.model.HuaweiCloudInstanceType;
import com.netflix.spinnaker.clouddriver.model.InstanceTypeProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HuaweiCloudInstanceTypeProvider
implements InstanceTypeProvider<HuaweiCloudInstanceType> {
    private final Cache cacheView;
    private final ObjectMapper objectMapper;

    @Autowired
    public HuaweiCloudInstanceTypeProvider(Cache cacheView, ObjectMapper objectMapper) {
        this.cacheView = cacheView;
        this.objectMapper = objectMapper;
    }

    public Set<HuaweiCloudInstanceType> getAll() {
        Collection data = this.cacheView.getAll(Keys.Namespace.INSTANCE_TYPES.ns, this.cacheView.filterIdentifiers(Keys.Namespace.INSTANCE_TYPES.ns, Keys.getInstanceTypeKey("*", "*", "*")));
        if (HuaweiCloudUtils.isEmptyCollection(data)) {
            return Collections.emptySet();
        }
        return data.stream().map(cacheData -> this.fromCacheData((CacheData)cacheData)).filter(it -> it != null).collect(Collectors.toSet());
    }

    private HuaweiCloudInstanceType fromCacheData(CacheData cacheData) {
        Map<String, String> parts = Keys.parse(cacheData.getId(), Keys.Namespace.INSTANCE_TYPES);
        if (parts.isEmpty()) {
            return null;
        }
        Flavor flavor = (Flavor)this.objectMapper.convertValue((Object)cacheData.getAttributes(), Flavor.class);
        return new HuaweiCloudInstanceType(flavor.getName(), parts.get("region"), parts.get("account"));
    }
}

