/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.huaweicloud.provider.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.openstack4j.openstack.vpc.v1.domain.Vpc;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.clouddriver.huaweicloud.HuaweiCloudUtils;
import com.netflix.spinnaker.clouddriver.huaweicloud.cache.Keys;
import com.netflix.spinnaker.clouddriver.huaweicloud.model.HuaweiCloudNetwork;
import com.netflix.spinnaker.clouddriver.model.NetworkProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HuaweiCloudNetworkProvider
implements NetworkProvider<HuaweiCloudNetwork> {
    private final Cache cacheView;
    private final ObjectMapper objectMapper;

    @Autowired
    public HuaweiCloudNetworkProvider(Cache cacheView, ObjectMapper objectMapper) {
        this.cacheView = cacheView;
        this.objectMapper = objectMapper;
    }

    public String getCloudProvider() {
        return "huaweicloud";
    }

    public Set<HuaweiCloudNetwork> getAll() {
        Collection data = this.cacheView.getAll(Keys.Namespace.NETWORKS.ns, this.cacheView.filterIdentifiers(Keys.Namespace.NETWORKS.ns, Keys.getNetworkKey("*", "*", "*")));
        if (HuaweiCloudUtils.isEmptyCollection(data)) {
            return Collections.emptySet();
        }
        return data.stream().map(cacheData -> this.fromCacheData((CacheData)cacheData)).filter(it -> it != null).collect(Collectors.toSet());
    }

    private HuaweiCloudNetwork fromCacheData(CacheData cacheData) {
        Map<String, String> parts = Keys.parse(cacheData.getId(), Keys.Namespace.NETWORKS);
        if (parts.isEmpty()) {
            return null;
        }
        Vpc vpc = (Vpc)this.objectMapper.convertValue((Object)cacheData.getAttributes(), Vpc.class);
        return new HuaweiCloudNetwork(parts.get("id"), vpc.getName(), parts.get("region"), parts.get("account"));
    }
}

